<?php
declare (strict_types = 1);

namespace app\middleware\admin;

use think\Session;

class AuthMiddleware
{
    /**
     * 处理请求
     *
     * @param \think\Request $request
     * @param \Closure       $next
     * @return Response
     */
    public function handle($request, \Closure $next)
    {
        $uInfo= session(ZBG_MANAGER);;
        if(empty($uInfo))
        {
            abort(503,json_encode(['msg'=>"帐号异常，请重新登录",'url'=>url('admin/public/index')]));
        }
        try {

            $controller = Request::controller();
            $action = Request::action();
            $currentUri= $controller."/".$action;
            // 调用权限验证服务
            $thriftClient = $thriftClient = app('ThriftClientService')->register();
            $userResponse = $thriftClient->call(
                'AuthService',
                'checkPermission',
                json_encode([
                    'token' => $uInfo->token,
                    'platid' => $uInfo->platid,
                    'route'=>$currentUri
                ])
            );
            $userData = parseResponseData($userResponse);
        } catch (\Exception $e)
        {
            session(ZBG_MANAGER,null);
            abort(503,json_encode(['msg'=>'服务不可用，请重新登录','url'=>url('login/index')]));
        }
        if(!$userData||$userResponse->code!=200)
        {
            if ($request->ajax())
            {
                return response()->json(['status' => 0,'info' => $userResponse->message??'登录异常，请重新登录']);
            }
            if($userResponse->code==403)
            {
                abort(403,json_encode(['msg'=>$userResponse->message??'登录异常，请重新登录']));
            }
            session(ZBG_MANAGER,null);
            abort(503,json_encode(['msg'=>$userResponse->message??'登录异常，请重新登录','url'=>url('login/index')]));
        }

        if($userData->openid!=$uInfo->openid)
        {
            session(ZBG_MANAGER,null);
            abort(503,json_encode(['msg'=>"'账号信息不一致，请重新登录",'url'=>url('login/index')]));
        }
        return $next($request);
    }
}
