<?php

use think\facade\Route;
use app\index\controller\Index;
use app\index\controller\Trade;
use app\index\controller\HelpCenter;
use app\index\controller\Seller;
use app\index\controller\My;
use app\index\controller\Payment;
use app\index\controller\Notice;
use app\index\controller\Login;
use app\index\middleware\GameMiddeware;
use app\index\middleware\AuthMiddleware;
use app\index\controller\Withdraw;

// 首页
Route::get('', Index::class. '@index');
// 选择区服
Route::group('index', function () {
    // 列表首页
    Route::post('game', Index::class. '@selectGame');
});
// 登录
Route::group('login', function () {
    // 退出登录
    Route::post('logout', Login::class. '@logout');
});

Route::group('/', function () {
    // 登录
    Route::group('login', function () {
        // 登录
        Route::post('login', Login::class. '@login');
    });
    // 买家
    Route::group('trade', function () {
        // 列表首页
        Route::get('index', Trade::class. '@index');
        // 详情-角色
        Route::get('role/:id', Trade::class. '@role');
        // 详情-金币
        Route::get('gold/:id', Trade::class. '@gold');
        // 详情-道具
        Route::get('prop/:id', Trade::class. '@prop');
    });
    // 站内信
    Route::group('notice', function () {
        // 列表首页
        Route::get('index', Notice::class. '@index');
    });

    // 帮助中心
    Route::group('help', function () {
        // 列表首页
        Route::get('index/[:mark]', HelpCenter::class. '@index');
    });
})->middleware([
    GameMiddeware::class,
]);

Route::group('/', function () {
    // 买家
    Route::group('trade', function () {
        // 收藏
        Route::post('collect', Trade::class. '@collect');
    });

    // 卖家
    Route::group('seller', function () {
        // 列表首页
        Route::get('index', Seller::class. '@index');
        // 详情
        Route::get('details/:type/:id', Seller::class. '@details');
        // 下架
        Route::post('close', Seller::class. '@close');
    });

    // 我的珍宝阁
    Route::group('my', function () {
        // 我的订单
        Route::get('index', My::class. '@index');
        // 我的收藏
        Route::get('collect', My::class. '@collect');
        // 校验订单
        Route::post('checkOrder', My::class. '@checkOrder');
        // 提交订单
        Route::get('order/:orderno', My::class. '@order');
        // 校验支付
        Route::post('checkPay', My::class. '@checkPay');
        // 支付跳转
        Route::get('dopay', My::class. '@dopay');
        // 订单取消
        Route::post('cancel', My::class. '@cancel');
    });

    // 站内信
    Route::group('notice', function () {
        // 列表首页
        Route::get('index', Notice::class. '@index');
        // 查看
        Route::post('read', Notice::class. '@read');
        // 删除
        Route::post('delete', Notice::class. '@delete');
    });

    // 提现
    Route::group('withdraw', function () {
        // 申请提现
        Route::post('withdraw', Withdraw::class. '@withdraw');
    });


})->middleware([
    AuthMiddleware::class,
]);

Route::group('payment', function () {
    Route::get('/alibackurl',Payment::class . '@alibackurl');
    Route::post('/alinotify',Payment::class . '@alinotify');
});
