<?php

namespace app\index\middleware;

use app\common\traits\HttpTraits;

class GameMiddeware
{
    use HttpTraits;
    public function handle($request, \Closure $next)
    {
        // 判断用户是否登录,如果未登录,获取选择游戏数据，如果未选择游戏，跳转到首页
        $member = session('member');
        $selectGame = session('selectGame');
        if (!$member && !$selectGame) {
            if ($request->isAjax()) {
                return $this->fail("请选择游戏", [], 403);
            } else {
                return redirect("/");
            }
        }
        $request->selectGame = $selectGame;
        $request->member = $member;
        $request->isLogin = $member ? true : false;
        return $next($request);
    }
}
