<?php

namespace app\index\middleware;

use app\common\traits\HttpTraits;

class AuthMiddleware
{
    use HttpTraits;
    public function handle($request, \Closure $next)
    {
        // 判断用户是否登录，如果未登录，弹出登录框
        $member = session('member');
        $selectGame = session('selectGame');
        // 用户信息
        $request->member = $member;
        $request->selectGame = $selectGame;

        // 判断是否登录
        if (!$member) {
            if ($request->isAjax()) {
                return $this->fail("请先登录", [], -1);
            } else {
//                return redirect("/");
            }
        }

        $request->isLogin = $member ? true : false;
        return $next($request);
    }
}
