<?php
namespace app\index\controller;

use app\common\controller\FrontController;
use app\common\model\TradeOrder;
use app\common\model\Trade as TradeModel;
use app\common\model\TradeWithdraw;
use think\Exception;
use think\facade\Db;

class Withdraw extends FrontController
{
    /**
     *  申请提现
     * @return \think\response\Json
     */
    public function withdraw()
    {
        if (!$this->request->isPost()) {
            return $this->fail("非法请求");
        }

        // todo-hanxinlong 频率

        $data = $this->request->param();
        $this->validate($data, [
            'orderno' => "require|min:1",
            'payuser' => "require|min:1",
            'aliname' => "require|min:1"
        ], [
            "orderno.require" => "参数错误",
            "orderno.min"     => "参数错误",
            "payuser.require" => "姓名不能为空",
            "payuser.min"     => "姓名不能为空",
            "aliname.require" => "支付宝账号不能为空",
            "aliname.min"     => "支付宝账号不能为空",
        ]);

        $orderno  = $data["orderno"] ?? "";
        $payuser  = $data["payuser"] ?? "";
        $aliname  = $data["aliname"] ?? "";
        $username = $this->request->member["username"] ?? "";

        $order = TradeOrder::field(["id", "tid", "orderno", "pay_status", "withdraw_status", "relationid", "ordertype"])
            ->where("orderno", $orderno)
            ->find();
        if (!$order) {
            return $this->fail("数据不存在");
        }

        $order = $order->toArray();
        $tid   = $order['tid'] ?? 0;

        if ($order["pay_status"] != TradeOrder::TO_PAY_STATUS_DONE) {
            return $this->fail("订单数据异常，无法提现");
        }

        $trade = TradeModel::field(["id", "username"])
            ->where("id", $tid)
            ->find();
        if (!$trade) {
            return $this->fail("数据异常");
        }

        $trade = $trade->toArray();
        $tousername  = $trade['username'] ?? "";
        if ($username != $tousername) {
            return $this->fail("该账号数据错误，无法提现");
        }

        // 查找是否已经申请提现
        $withdraw = TradeWithdraw::field(["id"])
            ->where("orderno", $orderno)
            ->find();
        if ($withdraw) {
            return $this->fail("您已申请提现，请勿重复提交");
        }

        $aData = [
            "game"       => $this->game,
            "serverid"   => $this->serverid,
            "tid"        => $tid,
            "username"   => $username,
            "orderno"    => $orderno,
            "relationid" => $order["relationid"] ?? 0,
            "ordertype"  => $order["ordertype"] ?? 0,
            "payuser"    => $payuser,
            "aliname"    => $aliname,
            "status"     => TradeWithdraw::STATUS_APPLY,
            "alitime"    => time()
        ];

        try {
            Db::startTrans();
            $res = TradeWithdraw::insertGetId($aData);
            if (!$res) {
                throw new Exception("申请失败");
            }

            $oRes = TradeOrder::where("id", ($order["id"] ?? 0))->update(['withdraw_status' => TradeWithdraw::STATUS_APPLY]);
            if (false === $oRes) {
                throw new Exception("申请失败.");
            }

            Db::commit();
        } catch (Exception $e) {
            Db::rollback();
            return $this->fail("申请失败");
        }

        return $this->success("申请成功");
    }
}