<?php
declare (strict_types = 1);

namespace app\index\controller;
use app\common\controller\FrontController;
use app\common\model\TradeNotice;
use app\common\model\TradeOrder;
use app\common\model\Trade as TradeModel;
use app\common\service\GameTradeService;
use think\Config;
use think\Exception;
use think\facade\Db;
use think\facade\Log;
use think\Request;
use Throwable;

class Payment extends FrontController
{
    //支付宝同步处理
    public function alibackurl()
    {
        require_once root_path() . 'extend/alipay/pagepay/service/AlipayTradeService.php';
        $config=config("alipay");
        $arr=$_GET;
        $alipaySevice = new \AlipayTradeService($config);
        $result = $alipaySevice->check($arr);
        if($result)
        {
            $out_trade_no = htmlspecialchars($_GET['out_trade_no']);
            header("Location:".url('/my/order/' . $out_trade_no));
            exit;
        }
        else {
            //验证失败
            abort(404, '支付异常');
        }
    }

    /**
     *  支付异步回调
     * @return string
     */
    public function alinotify()
    {
        require_once root_path() . 'extend/alipay/pagepay/service/AlipayTradeService.php';
        $config       = config("alipay");
        $data         = input("post.");
        Log::channel("payment")->info("支付回调-原始数据-日志记录, " . json_encode($data, JSON_UNESCAPED_UNICODE));
		
        $alipaySevice = new \AlipayTradeService($config);
        $result = $alipaySevice->check($data);
        $outTradeNo = $data['out_trade_no'] ?? "";
        $tradeNo     = $data['trade_no'] ?? '';
        $tradeStatus = $data['trade_status'] ?? '';
        $totalAmount = $data['total_amount'] ?? "";
        $gmtPayment = $data['gmt_payment'] ?? "";
		if (outTradeNo == "R2025070113544930114097") {
			return "success";
		}
        if (!$result) {
            Log::channel('payment')->error("支付回调-原始数据-签名校验失败, orderno：". $outTradeNo);
            return "fail";
        }

        if ($tradeStatus != 'TRADE_SUCCESS') {
            Log::channel('payment')->error("支付回调-原始数据-交易状态错误, orderno：". $outTradeNo . ", trade_status：" . $tradeStatus);
            return "fail";
        }

        if (!$this->changeOrderStatus($outTradeNo, $tradeNo, $totalAmount, $gmtPayment)) {
           return "fail";
        }

        return 'success';
    }

    /**
     *  支付回调订单状态修改
     * @param string $orderno
     * @param string $trade_no
     * @param string $amount
     * @param string $gmtPayment
     * @return boolean
     */
    protected function changeOrderStatus(string $orderno = "", string $trade_no = "", string $amount = "", string $gmtPayment = ""): bool
    {
        try {
            $orderObj = new TradeOrder();
            $order    = $orderObj->getDetailsByWhere(['orderno' => $orderno], [
                "id", "game", "serverid", "orderno", "tid", "pay_status", 'ordertype', 'relationid', 'tousername', 'tochaid', 'tochaname', 'order_details'
            ]);
            if (!$order) {
                throw new Exception("订单信息不存在, orderno：" . $orderno);
            }

            // 判断订单状态
            if ($order['pay_status'] == TradeOrder::TO_PAY_STATUS_DONE) {
                throw new Exception("订单已支付, orderno：" . $orderno);
            }

            if ($order['pay_status'] == TradeOrder::TO_PAY_STATUS_CACEL) {
                throw new Exception("订单已取消, orderno：" . $orderno);
            }

            // 修改订单状态
            // 修改各个表的交易状态和支付状态
            try {
                Db::startTrans();
                TradeOrder::where('orderno', $orderno)
                    ->update([
                        'pay_status' => TradeOrder::TO_PAY_STATUS_DONE,
                        'tradeno'    => $trade_no,
                        'paytime'    => strtotime($gmtPayment),
                    ]);

                $model    = TradeModel::getTypeTradeModel($order['ordertype']);
                $modelObj = app('app\\common\\model\\' . $model);
                $modelObj::where('id', $order['relationid'])->update([
                    'pay_status'    => TradeModel::TYPE_PAY_STATUS_DONE,
                    'trade_status'  => TradeModel::T_TRADE_STATUS_DONE
                ]);
                Db::commit();
            } catch (Throwable $e) {
                Db::rollback();
                throw $e;
            }

            // 转移道具和数据
            $this->transferData($order);
        } catch (Throwable $e) {
            Log::channel('payment')->error("支付回调-原始数据-" . json_encode([
                    'Message' => $e->getMessage(),
                    'Line'    => $e->getLine(),
                    'File'    => $e->getFile(),
                    'Trace'   => $e->getTraceAsString(),
                ], JSON_UNESCAPED_UNICODE));
            return false;
        }

        return true;
    }

    /**
     * 转移数据
     * @param $order
     * @return boolean
     */
    protected function transferData($order = [])
    {
        try {
            $type           = $order['ordertype'] ?? "-1";
            $game           = $order['game'] ?? "";
            $serverid       = $order['serverid'] ?? 0;
            $model          = TradeModel::getTypeTradeModel($type);
            $modelObj       = app('app\\common\\model\\' . $model);
            $transferConfig = config($game . ".transfer");
            $sendname       = $transferConfig['sendname'] ?? "";
            $sendcontent    = $transferConfig['sendcontent'] ?? "";
            $orderDetails   = $order['order_details'] ?? [];

            $apiStatus = TradeModel::T_API_STATUS_FAIL;
            switch ($type) {
                case TradeModel::TYPE_GOLD:
                    $gold      = $transferConfig[$model] ?? [];
                    $goodsSn   = $gold['goods_sn'] ?? "";
                    $goodsName = $gold['goods_name'] ?? "";
                    $res = GameTradeService::additem(
                        $game,
                        $serverid,
                            $order['tochaid'] ?? 0,
                        "$sendname",
                        $sendcontent,
                        [
                            ['goods_sn' => $goodsSn, 'goods_name' => $goodsName, 'itemcount' => (int)($orderDetails['num'] ?? 0)]
                        ]
                    );
                    if (($res['Data'] ?? 0) == 1) {
                        $apiStatus = TradeModel::T_API_STATUS_SUCCESS;
                    }
                    break;
                case TradeModel::TYPE_ROLES:
                    $res = GameTradeService::changechar($game, $serverid, $orderDetails['chaid'] ?? 0, $order['tousername'] ?? "");
                    if (($res['Data'] ?? 0) == 1) {
                        $apiStatus = TradeModel::T_API_STATUS_SUCCESS;
                    }
                    break;
                case TradeModel::TYPE_PROP:
                    $goodsSn   = $orderDetails['itemid'] ?? 0;
                    $goodsName = $orderDetails['goods_name'] ?? "";
                    $res = GameTradeService::additem(
                        $game,
                        $serverid,
                        $order['tochaid'] ?? 0,
                        $sendname,
                        $sendcontent,
                        [
                            ['goods_sn' => $goodsSn, 'goods_name' => $goodsName, 'itemcount' => (int)($orderDetails['num'] ?? 0)]
                        ]
                    );
                    if (($res['Data'] ?? 0) == 1) {
                        $apiStatus = TradeModel::T_API_STATUS_SUCCESS;
                    }
                    break;
            }
        } catch (Throwable $e) {
            Log::channel('payment')->error("支付回调-转移道具失败-" . json_encode([
                    'Message' => $e->getMessage(),
                    'Line'    => $e->getLine(),
                    'File'    => $e->getFile(),
                    'Trace'   => $e->getTraceAsString(),
                    'order'   => $order,
                ], JSON_UNESCAPED_UNICODE));
        }

        try {
            Db::startTrans();
            // 修改订单转移状态
            TradeOrder::where(['id' => $order['id']])->update(['api_status' => $apiStatus, 'totime' => time()]);
            // 修改交易转移状态
            $modelObj->where('id', $order['relationid'] ?? 0)->update(['api_status' => $apiStatus]);
            if ($apiStatus == TradeModel::T_API_STATUS_SUCCESS) {
                // 卖家
                (new TradeNotice())->addNotice(
                    $game, $order['serverid'] ?? 0, $order['tid'] ?? 0,  $orderDetails['username'] ?? "",
                    $order['orderno'] ?? "", $order['ordertype'] ?? 0, TradeNotice::NOTICE_TYPE_SUCCESS
                );
            }
            Db::commit();
        } catch (Throwable $e) {
            Log::channel('payment')->error("支付回调-修改订单状态失败-" . json_encode([
                    'Message' => $e->getMessage(),
                    'Line'    => $e->getLine(),
                    'File'    => $e->getFile(),
                    'Trace'   => $e->getTraceAsString(),
                    'order'   => $order,
                ], JSON_UNESCAPED_UNICODE));
        }
        return true;
    }
}