<?php

namespace app\index\controller;


use app\common\controller\FrontController;
use app\common\model\TradeNotice;

class Notice extends FrontController
{
    /**
     *  列表首页
     * @return string
     */
    public function index()
    {
        $data = [
            'game'     => $this->game,
            'serverid' => $this->serverid,
            'username'      => $this->request->member['username'] ?? ""
        ];
        $data = (new TradeNotice())->listOrderQuery($data);

        $this->assign([
            'lists' => $data['lists'] ?? [],
            'page'  => $data['page'] ?? "",
        ]);
        return $this->fetch("notice/index");
    }

    /**
     *  查看
     * @return \think\response\Json
     */
    public function read()
    {
        $id = (int)$this->request->post('id');
        if (!$id) {
            return $this->fail("缺少参数");
        }

        $notice = TradeNotice::where(['id' => $id])->whereNull("deleted_at")->find();
        if (!$notice) {
            return $this->fail("不存在");
        }

        $notice = $notice->toArray();
        if ($notice['is_read'] == TradeNotice::IS_READ_YES) {
            return $this->fail("无需操作");
        }

        $res = TradeNotice::where(['id' => $id])
            ->update([
                'is_read'  => TradeNotice::IS_READ_YES,
                'looktime' => time()
            ]);
        if (!$res) {
            return $this->fail("操作失败");
        }

        return $this->success("成功");
    }

    /**
     *  删除
     * @return \think\response\Json
     */
    public function delete()
    {
        $id = (int)$this->request->post('id');
        if (!$id) {
            return $this->fail("缺少参数");
        }
        $notice = TradeNotice::where(['id' => $id])->whereNull("deleted_at")->find();
        if (!$notice) {
            return $this->fail("数据不存在");
        }

        $res = TradeNotice::where(['id' => $id])
            ->update([
                'deleted_at' => date('Y-m-d H:i:s', time()),
            ]);
        if (!$res) {
            return $this->fail("删除失败");
        }
        return $this->success("删除成功");
    }
}