<?php
namespace app\index\controller;


use app\common\controller\FrontController;
use app\common\model\CtMember;

class Login extends FrontController
{
    /**
     * 游戏列表
     * @return \think\response\Json|\think\response\Redirect
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function login()
    {
        $data       = $this->request->post();
        $username   = $data['username'] ?? "";
        $password   = $data['password'] ?? "";
        $verifyCode = $data['verify_code'] ?? "";

        // 校验是否选择游戏
        if (!$this->game || !$this->serverid) {
            return $this->fail("请选择游戏", [], 403);
        }

        if ($username == "" || $password == "") {
            return $this->fail("账号或密码不能为空");
        }

        if (!captcha_check($verifyCode)) {
            return $this->fail("验证码错误，请重新输入!");
        }

        $memberInfo = CtMember::field(["uid", "username", "password", "salt"])
            ->where('username', $username)
            ->find();
        if (!$memberInfo) {
            return $this->fail("账号不存在");
        }

        $memberInfo = $memberInfo->toArray();
        $password   = md5(md5($password) . $memberInfo['salt']);
        if ($password != $memberInfo['password']) {
            return $this->fail("密码错误");
        }

        session("member", [
            "username" => $memberInfo['username'] ?? "",
            "game"     => $this->game,
            "serverid" => $this->serverid,
        ]);
        return $this->success('登录成功');
    }

    /**
     * 退出登录
     * @return \think\response\Json
     */
    function logout()
    {
        session("member", null);
        return $this->success("退出成功");
    }
}