<?php
namespace app\index\controller;


use app\common\controller\FrontController;
use app\common\model\TradeGame;

class Index extends FrontController
{
    /**
     *  游戏列表
     * @return string
     */
    public function index()
    {
        $lists = TradeGame::field("code,name,game,serverid,servername,image,status")->select()->toArray();
        $this->assign("lists", $lists);
        return $this->fetch('index/index');
    }

    /**
     * 选择游戏
     * @return \think\response\Json|void
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function selectGame()
    {
        $data = $this->request->post();
        $game = TradeGame::where("code", $data["code"])->where('status', TradeGame::STATUS_YES)->find();
        if (!$game) {
            return $this->fail("暂未开放");
        }
        $game = $game->toArray();
        $member = session('member');
        if (($member['game'] ?? "") != ($game['game'] ?? "") || ($member['serverid'] ?? 0) != ($game['serverid'] ?? 0)) {
            session("member", null);
        }

        session("selectGame", $game);
        return $this->success("获取成功");
    }
}