<?php
namespace app\index\controller;


use app\common\controller\FrontController;
use app\common\model\TradeHelpArticle;

class HelpCenter extends FrontController
{
    public function index()
    {
        $mark = $this->request->param('mark');

        $obj = new TradeHelpArticle();
        $lists = $obj->listQuery(['status' => 1], ['sort' => 'desc'], ['mark','title'], 100);

        $where = ['status' => 1];
        if ($mark) {
            $where['mark'] = $mark;
        }
        $details = $obj->getDetails($where);

        $this->assign([
            'lists' => $lists,
            'details' => $details,
            'mark' => $details['mark'] ?? "",
        ]);
        return $this->fetch("help-center/index");
    }
}