<?php
declare(strict_types=1);

namespace app\common\traits;

use think\response\Json;

trait HttpTraits
{
    /**
     * @notes 接口操作成功，返回信息
     * @param string $msg
     * @param array $data
     * @param int $code
     * @param int $show
     * @return \think\response\Json
     */
    public static function success(string $msg = 'success', array $data = [], int $code = 0, int $show = 1): Json
    {
        return self::result($code, $show, $msg, $data);
    }

    /**
     * @notes 接口操作失败，返回信息
     * @param string $msg
     * @param array $data
     * @param int $code
     * @param int $show
     * @return \think\response\Json
     */
    public static function fail(string $msg = 'fail', array $data = [], int $code = 500, int $show = 1): Json
    {
        return self::result($code, $show, $msg, $data);
    }

    /**
     * @notes 接口返回信息
     * @param int $code
     * @param int $show
     * @param string $msg
     * @param array $data
     * @param int $httpStatus
     * @return \think\response\Json
     */
    private static function result(int $code, int $show, string $msg = 'OK', array $data = [], int $httpStatus = 200): Json
    {
        $result = array(
            'code' => $code,
            'show' => $show,
            'msg' => $msg,
            'data' => $data
        );
        return json($result, $httpStatus);
    }
}