<?php

namespace app\common\service;

class shaiyaGameService
{
    /**
     * 请求地址
     * @var string
     */
    protected $base_uri = "";
    /**
     *  验签key
     * @var string
     */
    protected $key = "";

    /**
     *  游戏标识符
     * @var mixed|string
     */
    protected $game = "";

    /**
     *  游戏区服
     * @var int
     */
    protected $serverid = 0;

    public function __construct($game = "", $serverid = 0)
    {
        $serve = config($game . ".serve");
        $serve = handleEnvJsonToArray($serve ?: "");
        $this->key = config($game . ".key") ?: "";
        $this->serverid = $serverid;
        $this->game = $game;
        $this->base_uri = $serve[$serverid] ?? "";
    }

    /**
     * 查询珍宝阁上架
     * @param $listedid
     * @return false|mixed|string
     */
    public function treasurelisted($listedid = "")
    {
        $time = time();
        $sign = md5($listedid . $time .$this->key);
        $query = "?&listedid={$listedid}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/treasurelisted' . $query);
    }

    /**
     * 查询珍宝阁上架角色详情
     * @param $listedid
     * @return false|mixed|string
     */
    public function treasuredetail($listedid = "")
    {
        $time = time();
        $sign = md5($listedid . $time .$this->key);
        $query = "?&listedid={$listedid}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/treasuredetail' . $query);
    }

    /**
     * 查询背包仓库数据
     * @param $charid
     * @param $type 0->背包 1->角色仓库
     * @return false|mixed|string
     */
    public function charbackpack($charid = 0, $type = 0)
    {
        $time = time();
        $sign = md5($charid . $type. $time . $this->key);
        $query = "?&charid={$charid}&type={$type}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/charbackpack' . $query);
    }

    /**
     * 珍宝阁下架
     * @param $listedid
     * @return false|mixed|string
     */
    public function treasureremove($listedid = "")
    {
        $time = time();
        $sign = md5($listedid . $time . $this->key);
        $query = "?&listedid={$listedid}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/treasureremove' . $query);
    }

    /**
     * 查询账号是否可购买角色、金币、道具
     * @param string $username
     * @param string $listedid
     * @return false|mixed|string
     */
    public function isbuyrole(string $username = "", string $listedid = "")
    {
        $time = time();
        $sign = md5($username . $listedid . $time . $this->key);
        $query = "?&userid={$username}&listedid={$listedid}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/isbuyrole' . $query);
    }

    /**
     * 查询时装数据
     * @param int $charid
     * @return false|mixed|string
     */
    public function charfashion(int $charid = 0)
    {
        $time = time();
        $sign = md5($charid . $time . $this->key);
        $query = "?&charid={$charid}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/charfashion' . $query);
    }

    /**
     *  发送道具接口
     * @param int $charid
     * @param string $sendname
     * @param string $title
     * @param array $itemLists
     * @return false|mixed|string
     */
    public function additem(int $charid = 0, string $sendname = "", string $title = "", array $itemLists = [])
    {
        $time            = time();
        $sendname        = urlencode($sendname);
        $title           = urlencode($title);     // 道具名称，可以是道具名称也可以是组包名称，如（签到第一天礼包）
        $content         = urlencode($title);
        $expiretime      = strtotime('2024-07-30 00:00:00');     //过期时间 （待生效字段，写死）
        $itemnum         = count($itemLists);
        $goods_sn        = [];
        $goods_itemcount = [];
        foreach ($itemLists as $v) {
            $goods_sn[]        = $v['goods_sn'];
            $goods_itemcount[] = $v['itemcount'];
        }
        $itemid    = '(' . implode(',', $goods_sn) . ')';
        $itemcount = '(' . implode(',', $goods_itemcount) . ')';
        $sign      = md5($charid . $sendname . $title . $content . $expiretime . $itemnum . $itemid . $itemcount . $time . $this->key);
        $query     = "?&chaid={$charid}&sendname={$sendname}&title={$title}&content={$content}&expiretime={$expiretime}&itemnum={$itemnum}&itemid={$itemid}&itemcount={$itemcount}&time={$time}&sign={$sign}&";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/additem' . $query);
    }

    /**
     *  转移角色
     * @param int $charid
     * @param string $sendname
     * @param string $title
     * @param string $content
     * @param int $expiretime
     * @param array $itemLists
     * @return false|mixed|string
     */
    public function changechar(int $charid = 0, string $username = "")
    {
        $time            = time();
        $sign      = md5($charid . $username . $time . $this->key);
        $query     = "?&chaid={$charid}&username={$username}&time={$time}&sign={$sign}&";
        return (new HttpRequestService($this->game, ['timeout' => 30]))
            ->get($this->base_uri . '/changechar' . $query);
    }

    /**
     *  获取天神数据
     * @param int $charid
     * @return false|mixed|string
     */
    public function chargoddata(int $charid = 0)
    {
        $time = time();
        $sign = md5($charid . $time . $this->key);
        $query = "?&charid={$charid}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/chargoddata' . $query);
    }

    /**
     *  获取翅膀数据
     * @param int $charid
     * @return false|mixed|string
     */
    public function charwingdata(int $charid = 0)
    {
        $time = time();
        $sign = md5($charid . $time . $this->key);
        $query = "?&charid={$charid}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/charwingdata' . $query);
    }

    /**
     *  获取角色列表
     * @param string $username
     * @return false|mixed|string
     */
    public function getcha(string $username = "")
    {
        $time = time();
        $sign = md5($username . $time . $this->key);
        $query = "?&username={$username}&time={$time}&sign={$sign}";
        return (new HttpRequestService($this->game))
            ->get($this->base_uri . '/getcha' . $query);
    }
}