<?php

namespace app\common\service;

use alipay\pagepay\buildermodel\AlipayTransUniTranserBuilder;
use think\Exception;

class WithdrawTradeService
{
    /**
     * 提现
     * @param string $orderno
     * @param string $price
     * @param string $name
     * @param string $identity
     * @return \$1|false|mixed|\SimpleXMLElement
     * @throws \Exception
     */
    public static function withdrawTrade(string $orderno = "", string $price = "", string $name = "", string $identity = ""): array
    {
        try {
            require_once root_path() . 'extend/alipay/pagepay/service/AlipayTransferService.php';
            require_once root_path() . 'extend/alipay/pagepay/buildermodel/AlipayTransUniTranserBuilder.php';

            $config       = config("alipay_transfer_uni");
            $total_amount = trim($price);

            $transferuniBuilder = new AlipayTransUniTranserBuilder();
            $transferuniBuilder->setOutBizNo($orderno);
            $transferuniBuilder->setBizScene("DIRECT_TRANSFER");
            $transferuniBuilder->setProductCode("TRANS_ACCOUNT_NO_PWD");
            $transferuniBuilder->setTransAmount($total_amount);
            $transferuniBuilder->setOrderTitle("创天互娱珍宝阁提现");
            $transferuniBuilder->setPayeeInfo([
                'identity_type' => "ALIPAY_LOGON_ID",
                'name'          => $name,
                'identity'      => $identity,
            ]);

            $aop      = new \AlipayTransferService($config);
            $response = $aop->transferuni($transferuniBuilder);
            $response = json_decode(json_encode($response, JSON_UNESCAPED_UNICODE), true);

            // 提现失败
            if (($response["status"] ?? "") != "SUCCESS") {
                return [
                    "status" => false,
                    "msg"    => $response["sub_msg"] ?? "",
                    "data"   => []
                ];
            }
            return [
                "status" => true,
                "msg"    => "成功",
                "data"   => $response
            ];
        } catch (Exception $e) {
            $aop->writeLog(json_encode([
                'message' => $e->getMessage(),
                'code'    => $e->getCode(),
                'line'    => $e->getLine(),
                'file'    => $e->getFile(),
                'trace'   => $e->getTraceAsString()
            ]));
            return [
                "status" => false,
                "msg"    => "系统错误",
                "data"   => []
            ];
        }
    }
}