<?php
namespace app\common\service;

class GameTradeService
{
    /**
     *  获取上架珍宝阁上架信息
     * @param string $game
     * @param int $serverid
     * @param string $listed
     * @return array
     */
    public static function getTreasureListed(string $game = "", int $serverid = 0, string $listed = ""): array
    {
        $service = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        $res = $service->treasurelisted($listed);
        if ($res === false || !$res) {
            return [
                "status" => false,
                "msg"    => "查询珍宝阁上架信息失败",
                "data"   => [],
            ];
        }

        if (isset($res["Data"]) && is_numeric($res["Data"]) && $res["Data"] < 0) {
            return [
                "status" => false,
                "msg"    => "获取珍宝阁上架信息失败，Data：" . $res["Data"],
                "data"   => [],
            ];
        }

        return ['status' => true, "msg" => "success", "data" => $res];
    }
    /**
     *  获取上架珍宝阁上架信息-详情
     * @param string $game
     * @param int $serverid
     * @param string $listed
     * @return array
     */
    public static function getTreasureDetail(string $game = "", int $serverid = 0, string $listed = ""): array
    {
        $service = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        $res  = $service->treasuredetail($listed);
        if ($res === false) {
            return [
                "status" =>false,
                "msg"    => "查询珍宝阁角色详情失败",
                "data"   => [],
            ];
        }

        if (isset($res["Data"]) && is_numeric($res["Data"]) && $res["Data"] < 0 && !isset($res["data"])) {
            return [
                "status" => false,
                "msg"    => "获取珍宝阁角色详情失败，Data：" . $res["Data"],
                "data"   => [],
            ];
        }

        return ['status' => true, "msg" => "success", "data" => $res];
    }

    /**
     *  获取背包数据
     * @param string $game
     * @param int $serverid
     * @param int $charid
     * @param $type
     * @return array
     */
    public static function getCharbackpack(string $game = "", int $serverid = 0, int $charid = 0, $type = 0): array
    {
        $service = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        $res     = $service->charbackpack($charid, $type);
        if ($res === false) {
            return [
                "status" => false,
                "msg"    => "查询珍宝阁背包/角色仓库失败",
                "data"   => [],
            ];
        }

        if (isset($res["Data"]) && is_numeric($res["Data"]) && $res["Data"] < 0 && !isset($res["data"])) {
            return [
                "status" => false,
                "msg"    => "获取珍宝阁背包/角色仓库失败，Data：" . $res["Data"],
                "data"   => [],
            ];
        }

        return ['status' => true, "msg" => "success", "data" => $res['data'] ?? []];
    }
    /**
     *  获取外观数据
     * @param string $game
     * @param int $serverid
     * @param int $charid
     * @return array
     */
    public static function getCharfashion(string $game = "", int $serverid = 0, int $charid = 0): array
    {
        $service = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        $res     = $service->charfashion($charid);

        if ($res === false) {
            return [
                "status" => false,
                "msg"    => "查询珍宝阁外观数据失败",
                "data"   => [],
            ];
        }

        if (isset($res["Data"]) && is_numeric($res["Data"]) && $res["Data"] < 0 && !isset($res["data"])) {
            return [
                "status" => false,
                "msg"    => "获取珍宝阁外观数据失败，Data：" . $res["Data"],
                "data"   => [],
            ];
        }

        return ['status' => true, "msg" => "success", "data" => $res['data']];
    }
    /**
     *  获取天神数据
     * @param string $game
     * @param int $serverid
     * @param int $charid
     * @return array
     */
    public static function getChargoddata(string $game = "", int $serverid = 0, int $charid = 0): array
    {
        $service = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        $res     = $service->chargoddata($charid);

        if ($res === false) {
            return [
                "status" => false,
                "msg"    => "查询珍宝阁天神数据失败",
                "data"   => [],
            ];
        }

        if (isset($res["Data"]) && is_numeric($res["Data"]) && $res["Data"] < 0 && !isset($res["data"])) {
            return [
                "status" => false,
                "msg"    => "查询珍宝阁天神数据失败，Data：" . $res["Data"],
                "data"   => [],
            ];
        }

        return ['status' => true, "msg" => "success", "data" => $res['data'] ?? []];
    }
    /**
     *  获取翅膀数据
     * @param string $game
     * @param int $serverid
     * @param int $charid
     * @return array
     */
    public static function getCharwingdata(string $game = "", int $serverid = 0, int $charid = 0): array
    {
        $service = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        $res     = $service->charwingdata($charid);

        if ($res === false) {
            return [
                "status" => false,
                "msg"    => "查询珍宝阁翅膀数据失败",
                "data"   => [],
            ];
        }

        if (isset($res["Data"]) && is_numeric($res["Data"]) && $res["Data"] < 0 && !isset($res["data"])) {
            return [
                "status" => false,
                "msg"    => "查询珍宝阁翅膀数据失败，Data：" . $res["Data"],
                "data"   => [],
            ];
        }

        return ['status' => true, "msg" => "success", "data" => $res['data'] ?? []];
    }

    /**
     *  珍宝阁下架
     * @param string $game
     * @param int $serverid
     * @param string $listed
     */
    public static function treasureremove(string $game = "", int $serverid = 0, string $listed = "")
    {
        $obj = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        return $obj->treasureremove($listed);
    }

    /**
     *  获取玩家角色列表
     * @param string $game
     * @param int $serverid
     * @param string $username
     * @return mixed
     */
    public static function getGameRoleList(string $game = "", int $serverid = 0, string $username = "")
    {
        $obj = app("app\common\service\\" . $game . "GameService", ['game' => $game, 'serverid' => $serverid]);
        $roleLists = $obj->getcha($username);
        return $roleLists;
    }

    /**
     *  判断是否可以购买角色
     * @param string $game
     * @param int $serverid
     * @param string $username
     * @param string $listedid
     */
    public static function isbuyrole(string $game = "", int $serverid = 0, string $username = "", string $listedid = "")
    {
        $obj = app("app\\common\\service\\{$game}GameService", ['game' => $game, 'serverid' => $serverid]);
        return $obj->isbuyrole($username, $listedid);
    }
    /**
     *  发送角色道具
     * @param string $game
     * @param int $serverid
     * @param string $username
     * @param int $charid
     */
    public static function changechar(string $game = "", int $serverid = 0, int $charid = 0, string $username = "")
    {
        $obj = app("app\\common\\service\\{$game}GameService", ['game' => $game, 'serverid' => $serverid]);
        return $obj->changechar($charid, $username);
    }
    /**
     *  发送道具
     * @param string $game
     * @param int $serverid
     * @param string $username
     * @param int $charid
     */
    public static function additem(string $game = "", int $serverid = 0, int $charid = 0, string $sendname = "", string $goodsName = "", $data = [])
    {
        $obj = app("app\\common\\service\\{$game}GameService", ['game' => $game, 'serverid' => $serverid]);
        return $obj->additem($charid, $sendname, $goodsName, $data);
    }

}