<?php

namespace app\common\service;

class FileLockService
{
    public function getLockFilename($lockFileName): string
    {
        $path = runtime_path('lock');
        if (!is_dir($path)) {
            mkdir($path, 0755, true);
        }
        return $path . $lockFileName . '.lock';
    }

    public function acquireLock($lockKey = "", $lockTime = 5)
    {
        $lockFileName = $this->getLockFilename($lockKey);
        $fp = fopen($lockFileName, 'c+');
        if (!$fp) {
            return false;
        }

        if (!flock($fp, LOCK_EX | LOCK_NB)) {
            // 读取文件内容中的时间戳
            rewind($fp);
            $content = fread($fp, 20);
            $createTime = intval($content) ?: filemtime($lockFileName);

            // 检查是否超时
            if (time() - $createTime > $lockTime) {
                // 强制释放并删除文件
                flock($fp, LOCK_UN);
                fclose($fp);
                unlink($lockFileName);

                // 重新尝试获取锁
                $fp = fopen($lockFileName, 'c+');
                if (!$fp || !flock($fp, LOCK_EX | LOCK_NB)) {
                    return false;
                }
            } else {
                fclose($fp);
                return false;
            }
        }

        // 写入当前时间戳到文件内容
        ftruncate($fp, 0);
        fwrite($fp, time());
        fflush($fp);

        return $fp;
    }

    public function deleteLockFile($fp,$lockKey)
    {
        $lockFileName = $this->getLockFilename($lockKey);
        flock($fp, LOCK_UN);
        fclose($fp);
        unlink($lockFileName);
    }
}