<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeWithdraw extends Base
{
    protected $table = 'trade_withdraw';

    //  状态： 0-无 1-申请提现 2-提现成功 3-提现失败
    const STATUS_NO = 0;
    const STATUS_APPLY = 1;
    const STATUS_SUCCESS = 2;
    const STATUS_FAIL = 3;

    const WITHDRAW_STATUS = [
        self::STATUS_NO      => '— —',
        self::STATUS_APPLY   => '申请提现',
        self::STATUS_SUCCESS => '提现成功',
        self::STATUS_FAIL    => '提现失败',
    ];
    /**
     * 列表（分页）
     * @param  array   $where    条件
     * @param  array   $order    排序
     * @param  string  $fields   字段
     * @param  int     $limit    条数
     * @return array
     */
    public function listQuery($where=[], $order=['id'=>'desc'], $fields = '*', $limit=0)
    {
        $d = request()->get();
        $limit  = $limit>0 ? $limit : (isset($d['limit']) ? intval($d['limit']) : 10);
        $rs = $this->where($where)->order($order)->field($fields)->paginate($limit)->toArray();
        $data = $rs['data'] ?? [];
        if ($data) {
            $ordernos = array_column($data, 'orderno');
            $orderLists = (new TradeOrder())->getOrderListsByWhere([['orderno','in',$ordernos]], ['orderno', 'charge', 'price', 'amount']);
            $orderLists = array_column($orderLists, null, 'orderno');

            foreach ($data as &$v) {
                $order = $orderLists[$v['orderno']] ?? [];
                $v['charge'] = $order['charge'] ?? 0;
                $v['price'] = $order['price'] ?? 0;
                $v['amount'] = $order['amount'] ?? 0;
                $v['alitime_text'] = $v['alitime'] ? date('Y-m-d H:i:s', $v['alitime']) : '--';
                $v['withdrawtime_text'] = $v['withdrawtime'] ? date('Y-m-d H:i:s', $v['withdrawtime']) : '--';
            }
        }
        $rs['data'] = $data;
        return $rs;
    }
    /**
     *  获取详情
     * @param $data
     * @param $fields
     * @return array
     */
    public function getDetailsByWhere($where = [], $fields = ['*'])
    {
        $details = self::field($fields)
            ->where($where)
            ->find();
        if (!$details) {
            return [];
        }

        return $details->toArray();
    }
}