<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeWing extends Base
{
    protected $table = 'trade_wing';

    /**
     *  获取翅膀数据
     * @param string $game
     * @param int $serverid
     * @param int $tid
     * @return array
     */
    public function getWingLists(string $game, int $serverid, int $tid): array
    {
        $wingLists = self::field([
            "id", "game", "serverid", "tid", "wingid", "level",  "grade", "str", "dex", "rec", "int", "luc", "wis"
        ])
            ->where('game', $game)
            ->where("serverid", $serverid)
            ->where('tid', $tid)
            ->select()->toArray();

        if (!$wingLists) {
            return [];
        }

        $itemIdsLists = config($game . ".wing_item_ids");
        $itemIds = [];
        foreach ($wingLists as &$wing) {
            $itemId = $itemIdsLists[$wing['wingid']]['itemid'] ?? 0;
            if (!$itemId) {
                continue;
            }
            $wing['itemname'] = $itemIdsLists[$wing['wingid']]['label'] ?? "";
            $itemIds[$wing['wingid']] = $itemId;
        }

        $itemLists = [];
        if ($itemIds) {
            $itemLists = (new TradeItems())
                ->getItemsListsByItemids(
                    $game,
                    $serverid,
                    array_values($itemIds),
                    [
                        "itemname", "icon", "iconset", "itemid"
                    ]
                );
            $itemLists = array_column($itemLists, null, "itemid");
        }

        $totalWingData = [
            "str" => 0, "dex" => 0, "rec" => 0, "int" => 0, "luc" => 0, "wis" => 0
        ];

        $data = [];
        foreach ($wingLists as $value) {
            $itemId = $itemIds[$value['wingid']] ?? 0;
            $item = $itemLists[$itemId] ?? [];
            if (!$item) {
                continue;
            }

            $value['iconset']  = $item['iconset'] ?? "";
            $value['icon']    = $item['icon'] ?? 0;
            foreach (array_intersect_key($value, $totalWingData) as $k => $v) {
                $totalWingData[$k] += $v;
            }
            $data['lists'][] = $value;
        }

        if ($data) {
//            $data['total'] = $totalWingData;
        }

        unset($wingLists, $itemLists);
        return $data;
    }
}