<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeWar extends Base
{
    protected $table = 'trade_war';

    /**
     *  获取基础信息
     * @param string $game
     * @param int $serverid
     * @param int $tid
     * @return array
     */
    public function  getTradeWarList(string $game = "", int $serverid = 0, int $tid = 0): array
    {
        if (!$tid) {
            return [];
        }

        $items = self::field([
            "id", "game", "type", "hp", "sp", "mp", "str", "dex", "int", "wis",
            "rec", "luc", "ap", "dp", "af", "as", "am", "df", "ds", "dm"
        ])
            ->where("game", $game)
            ->where("serverid", $serverid)
            ->where("tid", $tid)
            ->select()
            ->toArray();
        if (!$items) {
            return [];
        }

        $data   = [];
        $config = config($game . ".war_type");
        foreach ($items as $item) {
            $item['tips_text']   = $config[$item["type"]]['tips'] ?? "";
            $item['type_text']   = $config[$item["type"]]['label'] ?? "";
            $data[$item["type"]] = $item;
        }
        ksort($data);

        unset($items);
        return $data;
    }
}