<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeStats extends Base
{
    protected $table = 'trade_stats';

    const STATS_TYPE_DAY = 0;
    const STATS_TYPE_MONTH = 1;
    const STATS_TYPE_YEAR = 2;
    const STATS_TYPES = [
        self::STATS_TYPE_DAY   => "按天",
        self::STATS_TYPE_MONTH => "按月",
        self::STATS_TYPE_YEAR  => "按年",
    ];


    /**
     *  获取列表
     * @param $where
     * @param $order
     * @param $fields
     * @param $limit
     * @return array
     * @throws \think\db\exception\DbException
     */
    public function listQuery($where=[], $order=['id'=>'desc'], $fields = '*', $limit = 0)
    {
        $d = request()->get();
        $limit  = $limit>0 ? $limit : (isset($d['limit']) ? intval($d['limit']) : 10);

        $game = $d['game'] ?? "";
        if ($game) {
            $where['game'] = $game;
        }

        $serverid = $d['serverid'] ?? 0;
        if ($serverid) {
            $where['serverid'] = $serverid;
        }

        $statsTime = $d['statstime'] ?? "";
        if ($statsTime) {
            $statsTimeArr = explode(" - ", $statsTime);
            $statsStartTime = $statsTimeArr[0] ?? "";
            $statsEndTime = $statsTimeArr[1] ?? "";

            if ($statsStartTime) {
                $where[] = ['stats_date', '>=', $statsStartTime];
            }

            if ($statsEndTime) {
                $where[] = ['stats_date', '<=', $statsEndTime];
            }
        }

        $where['ordertype'] = $d['ordertype'] ?? -1;
        $rs = $this->where($where)->order($order)->field($fields)->paginate($limit)->toArray();

        return $rs;
    }
}