<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeItems extends Base
{
    protected $table = 'trade_items';

    /**
     * 列表（分页）
     * @param  array   $where    条件
     * @param  array   $order    排序
     * @param  string  $fields   字段
     * @param  int     $limit    条数
     * @return array
     */
    public function listQuery($where=[], $order=['itemid'=>'desc'], $fields = '*', $limit = 0)
    {
        $d = request()->get();

        $itemname = $d['itemname'] ?? "";
        if ($itemname) {
            $where[] = ['itemname',"like", $itemname."%"];
        }

        $limit  = $limit>0 ? $limit : (isset($d['limit']) ? intval($d['limit']) : 10);

        $rs = $this->where($where)->order($order)->field($fields)->paginate($limit)->toArray();

        return $rs;
    }

    /**
     * 获取道具列表
     * @param string $game
     * @param int $serverid
     * @param array $itemids
     * @param array $fields
     * @return array
     */
    public function getItemsListsByItemids(string $game = "", int $serverid = 0, array $itemids = [], array $fields = ["*"]): array
    {
        $data = self::field($fields)
            ->where(['game'=>$game,'serverid'=>$serverid])
            ->whereIn('itemid',$itemids)
            ->select()->toArray();
        return $data;
    }

    /**
     * 获取道具列表
     * @param string $game
     * @param int $serverid
     * @param array $godids
     * @param array $fields
     * @return array
     */
    public function getItemsListsByGodis(string $game = "", int $serverid = 0, array $godids = [], array $fields = ["*"]): array
    {
        $data = self::field($fields)
            ->where(['game'=>$game,'serverid'=>$serverid])
            ->whereIn('godid',$godids)
            ->select()->toArray();
        return $data;
    }

    /**
     * 获取道具详情
     * @param string $game
     * @param int $serverid
     * @param int $itemid
     * @param array $fields
     * @return array
     */
    public function getDetailsByItemid(string $game = "", int $serverid = 0, int $itemid = 0, array $fields = ["*"])
    {
        $data = self::field($fields)
            ->where(['game'=>$game,'serverid'=>$serverid])
            ->where('itemid',$itemid)
            ->find();
        if (!$data) {
            return [];
        }
        return $data->toArray();
    }
}