<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeHelpCate extends Base
{
    protected $table = 'trade_help_cate';

    /**
     *  列表
     * @param $where
     * @param $order
     * @param $fields
     * @param $limit
     * @return array
     * @throws \think\db\exception\DbException
     */
    public function listQuery($where=[], $order=['id'=>'desc'], $fields = '*', $limit=0)
    {
        $d = request()->get();

        $name = $d['name'] ?? '';
        if ($name) {
            $where[] = ['name', 'like', '%'.$name.'%'];
        }
        $limit  = $limit>0 ? $limit : (isset($d['limit']) ? intval($d['limit']) : 10);

        $rs = $this->where($where)->order($order)->field($fields)->paginate($limit)->toArray();
        return $rs;
    }
}