<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeHelpArticle extends Base
{
    protected $table = 'trade_help_article';

    /**
     *  列表
     * @param $where
     * @param $order
     * @param $fields
     * @param $limit
     * @return array
     * @throws \think\db\exception\DbException
     */
    public function listQuery($where=[], $order=['id'=>'desc'], $fields = '*', $limit=0)
    {
        $d = request()->get();

        $limit  = $limit>0 ? $limit : (isset($d['limit']) ? intval($d['limit']) : 10);

        $rs = $this->where($where)->order($order)->field($fields)->paginate($limit)->toArray();
        return $rs['data'] ?? [];
    }

    /**
     *  获取数据
     * @param array $where
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getDetails(array $where)
    {
        $rs = $this->field(['mark', 'title', 'content'])
            ->where($where)
            ->order('sort', 'desc')
            ->find();
        if (!$rs) {
            return [];
        }
        return $rs->toArray();
    }
}