<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeGod extends Base
{
    protected $table = 'trade_god';

    /**
     *  获取天神数据
     * @param string $game
     * @param int $serverid
     * @param int $tid
     * @return array
     */
    public function getGodLists(string $game, int $serverid, int $tid): array
    {
        $godLists = self::field([
            "id", "game", "serverid", "tid", "godid", "index", "str", "dex", "rec", "int", "luc", "wis", "hp", "mp", "sp",
            "at", "atv", "df", "dfm", "level", "mul"
        ])
            ->where('game', $game)
            ->where("serverid", $serverid)
            ->where('tid', $tid)
            ->select()->toArray();

        if (!$godLists) {
            return [];
        }

        $godids    = array_values(array_unique(array_column($godLists, 'godid')));
        $itemLists = [];
        if ($godids) {
            $itemLists = (new TradeItems())
                ->getItemsListsByGodis(
                    $game,
                    $serverid,
                    $godids,
                    [
                        "itemname", "icon", "iconset", "godid"
                    ]
                );
            $itemLists = array_column($itemLists, null, "godid");
        }

        $totalGodData = [
            "str" => 0, "dex" => 0, "rec" => 0, "int" => 0, "luc" => 0, "wis" => 0, "hp" => 0, "mp" => 0, "sp" => 0,
            "at"  => 0, "atv" => 0, "df" => 0, "dfm" => 0
        ];

        $data = [];
        foreach ($godLists as $value) {
            $item = $itemLists[$value['godid']] ?? [];
            if (!$item) {
                continue;
            }

            $value['level'] = bcsub($value['level'], bcmul($value['mul'], 5));
            $value['itemname'] = $item['itemname'] ?? "";
            $value['iconset']  = $item['iconset'] ?? "";
            $value['icon']    = $item['icon'] ?? 0;
            foreach (array_intersect_key($value, $totalGodData) as $k => $v) {
                $totalGodData[$k] += $v;
            }
            $data['part'][] = $value;
        }

        if ($data) {
//            $data['total'] = $totalGodData;
        }

        unset($godLists, $itemLists);
        return $data;
    }
}