<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeGame extends Base
{
    protected $table = 'trade_game';

    // 游戏状态： 0-关闭 1-开启
    const STATUS_NO = 0;
    const STATUS_YES = 1;

    /**
     *  游戏列表
     * @return array
     */
    public function getGameLists()
    {
        $data = self::field(['id', 'name', 'game', 'serverid', 'servername'])
            ->where('status', self::STATUS_YES)
            ->select()->toArray();
        if (!$data) {
            return ['game_lists' => [], 'serverid_lists' => []];
        }

        $gameLists = ['' => "请选择游戏"];
        $serverLists = [];
        foreach ($data as $value) {
            $gameLists[$value['game']] = $value['name'];
            if (!isset($serverLists[$value['game']])) {
                $serverLists[$value['game']][0] = "请选择区服";
            }
            $serverLists[$value['game']][$value['serverid']] = $value['servername'];
        }


        return ['game_lists' => $gameLists, 'serverid_lists' => $serverLists];
    }
}