<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeEquip extends Base
{
    protected $table = 'trade_equip';

    /**
     *  穿戴装备
     * @param string $game
     * @param int $serverid
     * @param int $tid
     * @return array
     */
    public function getTradeEquipList(string $game = "", int $serverid = 0, int $tid = 0): array
    {
        if (!$tid) {
            return [];
        }

        $equipLists = self::field([
            "id", "game", "type", "itemid", "st", "hp", "sp", "mp", "str", "dex", "int", "wis",
            "rec", "luc", "ia", "iav", "ide", "idm", "rd", "sl", "cj", "g1",
            "g2", "g3", "g4", "g5", "g6",
        ])
            ->where("game", $game)
            ->where("serverid", $serverid)
            ->where("tid", $tid)
            ->select()
            ->toArray();
        if (!$equipLists) {
            return [];
        }

        // 获取宝石ID
        $gids = [];
        $gFields = ['g1', 'g2', 'g3', 'g4', 'g5', 'g6'];
        foreach ($gFields as $gField) {
            $gids = array_merge($gids, array_filter(array_column($equipLists, $gField)));
        }

        $tradeItemsObj = new TradeItems();
        // 宝石名称
        $gLists = [];
        if ($gids) {
            $gLists = $tradeItemsObj
                ->getItemsListsByItemids(
                    $game,
                    $serverid,
                    $gids,
                    ["itemname", "itemid"]
                );
            $gLists = array_column($gLists, "itemname", "itemid");
        }

        $itemids = array_values(array_unique(array_column($equipLists, 'itemid')));
        $itemLists = [];
        if ($itemids) {
            $itemLists = $tradeItemsObj
                ->getItemsListsByItemids(
                    $game,
                    $serverid,
                    $itemids,
                    [
                        "game", "itemname", "text", "itemid", "icon", "level", "dex", "og", "attacktime", "effect1", "effect2", "effect3",
                        "effect4", "consthp", "constsp", "constmp", "conststr", "constdex", "constrec", "constint", "constwis", "constluc",
                        "iconset", 'extduration'
                    ]
                );
            $itemLists = array_column($itemLists, null, "itemid");
        }

        $dexColor = config($game . ".dex_color"); // 名称色值
        $og = config($game . ".og"); // 绑定

        $data   = [];
        $config = config($game . ".equip_type");
        foreach ($equipLists as &$value) {
            $item            = $itemLists[$value["itemid"]] ?? [];
            if (!$item) {
                continue;
            }
            $item['og_text'] = $og[$item['og'] ?? 0] ?? "";
            $item['dex_rgb'] = $dexColor[$item['dex'] ?? 0] ?? "";
            $item['text']    = itemFieldHandle($game, "text", $item);

            // 宝石名称获取
            foreach ($gFields as $v) {
                $value[$v . "_text"] = $gLists[$value[$v]] ?? "";
            }

            $value['item']   = $item;
            $res = isFacade($game, $item);

            // 外观
            if (($res['is_facade'] ?? false)) {
                $data['facade'][$res['type']][] = $value;
            } else {
                $data[$value["type"]]["type_text"]           = $config[$value["type"]]['label'] ?? "";
                $data[$value["type"]]['equip'][$value['st']] = $value;
            }
        }

        unset($equipLists, $itemLists, $itemLists, $gLists);
        return $data;
    }

    /**
     * 获取装备列表
     * @param string $game
     * @param int $serverid
     * @param array $tids
     * @param array $fields
     * @return array
     */
    public function getEquipListsByTids(string $game = "", int $serverid = 0, array $tids = [], array $fields = ["*"]): array
    {
        $data = self::field($fields)
            ->where(['game'=>$game,'serverid'=>$serverid])
            ->whereIn('tid',$tids)
            ->select()->toArray();
        return $data;
    }
}