<?php

namespace app\common\model;

use app\admin\model\Base;

class TradeBackPack extends Base
{
    protected $table = 'trade_backpack';

    /**
     *  类型： 0-背包 1-角色仓库 2-外观
     */
    const TYPE_PACKSACK = 0;
    const TYPE_ROLE_BACKPACK = 1;
    const TYPE_FACADE = 2;

    /**
     *  获取仓库数据
     * @param string $game
     * @param int $serverid
     * @param int $tid
     * @return array
     */
    public function getBackpackList(string $game = "", int $serverid = 0, int $tid = 0): array
    {
        $backpackLists = self::field(["type", "itemid", "num"])
            ->where('game', $game)
            ->where("serverid", $serverid)
            ->where('tid', $tid)
            ->select()->toArray();

        if (!$backpackLists) {
            return [];
        }

        $itemids = array_column($backpackLists, 'itemid');
        $itemLists = (new TradeItems())
            ->getItemsListsByItemids(
                $game,
                $serverid,
                $itemids,
                [
                    "game", "itemname", "text", "itemid", "icon", "level", "dex", "og", "attacktime", "effect1", "effect2", "effect3",
                    "effect4", "consthp", "constsp", "constmp", "conststr", "constdex", "constrec", "constint", "constwis", "constluc",
                    "iconset", "extduration"
                ]
            );
        $itemLists = array_column($itemLists, null, "itemid");

        $dexColor = config($game . ".dex_color"); // 名称色值
        $og = config($game . ".og"); // 绑定

        // 数据处理
        $data = [];
        foreach ($backpackLists as $item) {
            $temp = $itemLists[$item['itemid']] ?? [];
            if (!$temp) {
                continue;
            }

            $temp['og_text'] = $og[$temp['og'] ?? 0] ?? "";
            // 计算道具类型
            $temp['type'] = $item['type'];
            $temp['num'] = $item['num'] ?? 0;
            $temp['dex_rgb'] = $dexColor[$temp['dex']] ?? "";
            $temp['text'] = itemFieldHandle($game, "text", $temp);

            $res = isFacade($game, $temp);
            $temp['itemtypeid'] = $res['typeid'] ?? 0;
            // 外观，传说及以上 && extduration不等于-1
            if (($res['is_facade'] ?? false)) {
                $data['facade'][$res['type']][] = $temp;
            }

            $data[$item['type']][] = $temp;
        }

        unset($backpackLists, $itemLists);
        return $data;
    }
}