<?php
namespace app\common\controller;

use app\common\model\TradeHelpArticle;
use app\common\model\TradeNotice;
use app\index\BaseController;
use app\common\traits\HttpTraits;

class FrontController extends BaseController
{
    use HttpTraits;


    protected $game = "";

    protected $serverid = 0;

    protected function initialize()
    {
        parent::initialize();
        // 平台介绍
        $layoutIntro = config("app.plateform_intro");

        // 交易手册
        $vadeLists = TradeHelpArticle::field(['mark', 'title', 'class'])
            ->where(['status' => 1, 'cate_id' => 1])
            ->order('sort', 'desc')->select()->toArray();

        if ($this->request->isLogin) {
            $this->game     = $this->request->member['game'] ?? "";
            $this->serverid = $this->request->member["serverid"] ?? 0;
        } else {
            $this->game     = $this->request->selectGame["game"] ?? "";
            $this->serverid = $this->request->selectGame["serverid"] ?? 0;
        }

        $noticeDot = false;
        $username  = $this->request->member['username'] ?? "";
        if ($this->request->member['username'] ?? "") {
            $noticeDot = TradeNotice::where([
                'game'     => $this->game,
                'serverid' => $this->serverid,
                'username' => $username,
                'is_read'  => TradeNotice::IS_READ_NO,
            ])->find();
        }

        $config = config($this->game . ".serverid_background");
        $this->assign([
            "layout_intro"     => $layoutIntro,
            "vade_lists"       => $vadeLists,
            "username"         => $this->request->member["username"] ?? "",
            "is_login"         => $this->request->isLogin ? 1 : 0,
            'background_class' => $config[$this->serverid] ?? "",
            'notice_dot'       => (bool)$noticeDot,
            'kf_url'           => config('app.kf_url'),
        ]);
    }
}