<?php
namespace app\common\command;
use app\common\model\Trade;
use app\common\model\TradeNotice;
use think\console\Command;
use think\console\Input;
use think\console\input\Argument;
use think\console\Output;
use think\Exception;
use think\facade\Db;
use think\facade\Log;

/**
 *  关闭交易
 */
class CloseTrade extends Command
{
    protected function configure()
    {
        $this->setName('CloseTrade')
            ->addArgument('type', Argument::REQUIRED, "执行类型：0-金币 1-角色 2-道具")
            ->setDescription('交易关闭');
    }

    protected function execute(Input $input, Output $output)
    {
        $output->info(date("Y-m-d H:i:s") . "交易关闭-脚本开始执行");

        $limit = 100;
        // 关闭半小时内，超时关闭
        try {
            $type = (int)$input->getArgument('type');

            $tradeObj = new Trade();
            $model = Trade::getTypeTradeModel($type);
            $modelObj = app('app\\common\\model\\' . $model);

            $lists = $modelObj::field([
                    "id", "game", "serverid", "tid", "username", "trade_status"
                ])
                ->where('outtime', '<=', time())
                ->where('outtime', '>=', time() - 1800)
                ->where('trade_status', Trade::T_TRADE_STATUS_SELL)
                ->limit($limit)
                ->select()->toArray();
            if (!$lists) {
//                throw new Exception(Trade::TYPE[$type] . "交易无数据");
                return;
            }

            $tids = array_column($lists, 'tid');
            $syncTradeNoLists = $tradeObj->whereIn('id', $tids)->column('sync_tradeno', 'id');

            // 组装数据
            foreach ($lists as $v) {
                Db::startTrans();
                try {
                    $syncTradeNo = $syncTradeNoLists[$v['tid']] ?? 0;
                    // 下架接口
                    $tradeObj->closeTrade([
                        'game' => $v['game'], 'serverid' => $v['serverid'], 'id' => $v['id'], 'type' => $type, 'tid' => $v['tid'],
                        'username' => $v['username'], 'sync_tradeno' => $syncTradeNo, 'trade_status' => Trade::T_TRADE_STATUS_SYSTEM_DOWN,
                        'notice_type' => TradeNotice::NOTICE_TYPE_ORDER_DOWN
                    ]);

                    Db::commit();
                } catch (\Throwable $e) {
                    Db::rollback();
                    throw $e;
                }
            }
        } catch (Exception $e) {
            $output->error(date("Y-m-d H:i:s") . "交易关闭-脚本执行出错：" . $e->getMessage() . ", Line:" . $e->getLine() . ", File:" . $e->getFile());
            Log::channel("command")->info("交易关闭-处理出错：" . json_encode([
                    'Message' => $e->getMessage(),
                    'Line'    => $e->getLine(),
                    'File'    => $e->getFile(),
                    'Trace'   => $e->getTraceAsString(),
                ], JSON_UNESCAPED_UNICODE));
        }
        $output->info(date("Y-m-d H:i:s") . "交易关闭-脚本开始结束");
    }
}