<?php
namespace app\common\command;

use app\common\model\TradeOrder;
use think\console\Command;
use think\console\Input;
use think\console\Output;
use think\Exception;
use think\facade\Db;
use think\facade\Log;

/**
 *  关闭超时订单
 */
class CloseOrder extends Command
{
    protected function configure()
    {
        $this->setName('CloseOrder')
            ->setDescription('订单状态修改');
    }

    protected function execute(Input $input, Output $output)
    {
        $output->info(date("Y-m-d H:i:s") . "超时订单-脚本开始执行");
        $limit = 100;
        // 超时订单关闭
        $lists = TradeOrder::field(['id', 'game', 'serverid', 'ordertype', 'orderno', 'relationid', 'tid', 'tousername', 'order_details'])
            ->where('pay_status', TradeOrder::TO_PAY_STATUS_TODO)
            ->where('addtime', '<', time() - config("app.order_outtime"))
            ->limit($limit)
            ->select()
            ->toArray();
        if (!$lists) {
//            $output->info("超时订单-暂无数据处理.......");
            return false;
        }

        foreach ($lists as $item) {
            $item['order_details'] = json_decode($item['order_details'] ?: "", true);

            try {
                Db::startTrans();
                (new TradeOrder())->cancelOrder($item);
                Db::commit();
            } catch (Exception $e) {
                Db::rollback();
                Log::channel("command")->info("超时订单-处理出错：" . json_encode([
                        'Message' => $e->getMessage(),
                        'Line'    => $e->getLine(),
                        'File'    => $e->getFile(),
                        'Trace'   => $e->getTraceAsString(),
                    ], JSON_UNESCAPED_UNICODE));
            }
        }
        $output->info(date("Y-m-d H:i:s") . "超时订单-脚本结束执行");
    }
}