<?php
namespace app\common\command;
use app\common\model\Trade;
use app\common\model\TradeGold;
use app\common\model\TradeProp;
use app\common\model\TradeRole;
use think\console\Command;
use think\console\Input;
use think\console\Output;
use think\Exception;
use think\facade\Log;

/**
 *  关闭交易
 */
class ChangeTradeStatus extends Command
{
    protected function configure()
    {
        $this->setName('ChangeTradeStatus')
            ->setDescription('交易状态修改：公示期->出售期');
    }

    protected function execute(Input $input, Output $output)
    {
        $output->info(date("Y-m-d H:i:s") . "交易状态修改：公示期->出售期-脚本开始执行");

        try {

            TradeGold::where('trade_status', Trade::T_TRADE_STATUS_PUB)
                ->where('created_at', '<=', date("Y-m-d H:i:s", (time() - config('app.trade_public_time'))))
                ->update(['trade_status' => Trade::T_TRADE_STATUS_SELL]);

            TradeRole::where('trade_status', Trade::T_TRADE_STATUS_PUB)
                ->where('created_at', '<=', date("Y-m-d H:i:s", (time() - config('app.trade_public_time'))))
                ->update(['trade_status' => Trade::T_TRADE_STATUS_SELL]);

            TradeProp::where('trade_status', Trade::T_TRADE_STATUS_PUB)
                ->where('created_at', '<=', date("Y-m-d H:i:s", (time() - config('app.trade_public_time'))))
                ->update(['trade_status' => Trade::T_TRADE_STATUS_SELL]);

        } catch (Exception $e) {
            $output->error(date("Y-m-d H:i:s") . "交易状态修改：公示期->出售期-脚本执行出错：" . $e->getMessage() . ", Line:" . $e->getLine() . ", File:" . $e->getFile());
            Log::channel("command")->info("交易状态修改：公示期->出售期-处理出错：" . json_encode([
                    'Message' => $e->getMessage(),
                    'Line'    => $e->getLine(),
                    'File'    => $e->getFile(),
                    'Trace'   => $e->getTraceAsString(),
                ], JSON_UNESCAPED_UNICODE));
        }
        $output->info(date("Y-m-d H:i:s") . "交易状态修改：公示期->出售期-脚本开始结束");
    }
}