<?php
use GuzzleHttp\Client;

/**
 * replaceMiddleCharacters
 * 用于替换字符串的中间字符为星号
 */
if (!function_exists('replaceMiddleCharacters')) {
    function replaceMiddleCharacters($str) {
        $strLength = strlen($str);
        if ($strLength < 4) {
            return $str;
        }
        if ($strLength > 9) {
            $prefix = substr($str, 0, 3);
            $suffix = substr($str, -4);
            $masked = '****';
            return $prefix . $masked . $suffix;
        } else {
            $prefix = substr($str, 0, 2);
            $masked = str_repeat('*', $strLength - 2);
            return $prefix . $masked;
        }
    }
}

if (!function_exists('isSpecialPhoneNumber')) {
    function isSpecialPhoneNumber($phoneNumber)
    {
        // 用于匹配 162、165、167、170 和 171 开头的手机号码
        $regex = '/^(16[257]|17[01])\d{8}$/';
        if (preg_match($regex, $phoneNumber)) {
            return true;
        } else {
            return false;
        }
    }
}

if (!function_exists('arrayToJson')) {
    /**
     *  数组转json
     * @param $data
     * @return false|string
     */
    function arrayToJson($data = [])
    {
        return json_encode($data, JSON_UNESCAPED_UNICODE);
    }
}

if (!function_exists('calculateRemainingTimeText')) {
    /**
     *  计算剩余时间
     * @param $startTime
     * @param $endTime
     * @return array
     */
    function calculateRemainingTimeText($startTime = 0, $endTime = 0) {
        $diffTime = $endTime - $startTime;

        $days       = number_format(bcdiv($diffTime, 86400, 6), 6);       // 计算天数
        $pubTime    = (int)config('app.trade_public_time');
        $sellerTime = (int)config('app.trade_seller_time');
        $pubDays    = number_format(bcdiv($pubTime, 86400, 6), 6);
        $sellerDays = number_format(bcdiv($sellerTime, 86400, 6), 6);
        $totalDays  = number_format(bcadd($pubDays, $sellerDays, 6), 6);

        if ($days >= $totalDays) {
            $type = 3; // 已结束
            return [$type => "已结束"];
        }

        if ($days <= $pubDays) {
            // 如果小于等于3，公示期
            $diffTime = $startTime + $pubTime - $endTime;
            $type     = 2; // 公示期
        } else if ($days <= $totalDays) {
            $diffTime = ($startTime + $sellerTime + $pubTime) - $endTime;
            $type     = 1; // 出售中
        }

        $days    = floor($diffTime / 86400);       // 计算天数
        $hours   = floor(($diffTime % 86400) / 3600);  // 剩余小时
        $minutes = floor(($diffTime % 3600) / 60);   // 剩余分钟

        $result = [];
        if ($days > 0) {
            $result[] = sprintf("%d天", $days);
        }

        if ($hours > 0) {
            $result[] = sprintf("%02d小时", $hours);
        }

        $result[] = sprintf("%02d分", $minutes);
        return [$type => implode("", $result)];
    }
}
if (!function_exists('calculateRemainingTime')) {
    /**
     *  计算剩余时间
     * @param $startTime
     * @param $endTime
     * @return array
     */
    function calculateRemainingTime($startTime = 0, $endTime = 0, $overtime = 0) {
        $diffTime = $endTime - $startTime;

        if ($diffTime >= $overtime) {
            $type = 1; // 已结束
            return [$type => "已结束"];
        }

        $diffTime = $startTime + $overtime - $endTime;

        $type = 0;
        $days    = floor($diffTime / 86400);       // 计算天数
        $hours   = floor(($diffTime % 86400) / 3600);  // 剩余小时
        $minutes = floor(($diffTime % 3600) / 60);   // 剩余分钟

        $result = [];
        if ($days > 0) {
            $result[] = sprintf("%d天", $days);
        }

        if ($hours > 0) {
            $result[] = sprintf("%02d小时", $hours);
        }

        $result[] = sprintf("%02d分", $minutes);

        return [$type => implode("", $result)];
    }
}
if (!function_exists('calcXAndY')) {
    /**
     * 计算x和y
     * @param $icon
     * @return float[]|int[]
     */
    function calcXAndY($icon = 0) {
        $row = (int)($icon / 16);
        $index = (int)($icon % 16);

        // background-position: calc(-1 * (目标列索引 - 1) * 小图宽度) calc(-1 * (目标行索引 - 1) * 小图高度);
        if ($index == 0) {
            $index = 16;
            $row = $row - 1;
        }
        $x = -1 * ($index - 1) * 32;
        $y = -1 * ($row) * 32;

        return [
            'x' => $x,
            'y' => $y,
        ];
    }
}

if (!function_exists('__war')) {
    /**
     * 基础信息计算
     * @param $game
     * @param $key
     * @param $type
     * @param $data
     * @return mixed|string
     */
    function __war($game = "", $key = "", $type = 0, $data = []) {
        $string = "";

        switch ($type) {
            case 0:
                // 配置列表
                $configLists = config($game . ".war");
                // 配置
                $config = $configLists[$key] ?? "";
                // 配置数据
                $attr = $config["label"] ?? "";
                $options = $config["options"] ?? [];

                $value = $data[$key] ?? "";
                if ($options) {
                    $value = $options[$value] ?? "";
                }

                $string = $attr . "：" . $value;
                break;
        }

        return $string;
    }
}

if (!function_exists('__equip')) {
    /**
     * 穿戴信息
     * @param $game
     * @param $type
     * @param $st
     * @param $data
     * @return mixed|string
     */
    function __equip($game = "", $type = 0, $st = 0, $data = []) {
        $string = "";
        switch ($type) {
            case 0:
                if ($data) {
                    // 配置列表
                    $icon = calcXAndY($data['icon']);
                    $string = '<img style="background-image: url('.$data['iconset'].');
                            background-position-x:'.$icon['x'].'px;background-position-y:'.$icon['y'].'px;
                            ">';
                }
                break;
            case 1:
                if ($data) {
                    // 配置列表
                    $icon = calcXAndY($data['icon']);
                    $string = '<img class="layui-upload-img" style="background-image: url('.$data['iconset'].');background-position-x:'.$icon['x'].'px;background-position-y:'.$icon['y'].'px;width:32px;height:32px;">';
                }
                break;
        }

        return $string;
    }
}

if (!function_exists('__backpack')) {
    /**
     *  仓库信息
     * @param string $game
     * @param int $type 0
     * @param int $mode 模块，0-背包 1-角色仓库 2-外观
     * @param array $data
     * @return string
     */
    function __backpack(string $game = "", int $type = 0, int $mode = 0, array $data = []) {
        $string = "";
        switch ($type) {
            case 0:
                if (isset($data['item'])) {
                    $data = $data['item'] ?? [];
                }
                $icon = calcXAndY($data['icon']);
                $string = '<img style="background-image: url('.$data['iconset'].');
                            background-position-x:'.$icon['x'].'px;background-position-y:'.$icon['y'].'px;
                            ">';
                break;
            case 1:
                if (isset($data['item'])) {
                    $data = $data['item'] ?? [];
                }
                $icon = calcXAndY($data['icon']);
                $string = '<img class="layui-upload-img" style="background-image: url('.$data['iconset'].');background-position-x:'.$icon['x'].'px;background-position-y:'.$icon['y'].'px;width:32px;height:32px;">';
                break;
        }

        return $string;
    }
}

if (!function_exists('itemDesc')) {
    /**
     *  道具描述信息处理
     * @param string $game
     * @param string $field
     * @param array $data
     * @return string
     */
    function itemFieldHandle(string $game = "", string $field = "",array $data = []) {
        $colorMap = config($game . ".text_color");
        $pattern = '/\{c([a-zA-Z0-9]+)\}(.*?)\{\/c\}/s';

        $string = $data[$field] ?? "";

        // 使用正则替换处理颜色标签
        $string = preg_replace_callback($pattern, function($matches) use ($colorMap) {
            $code =$matches[1];
            $content =$matches[2];

            if(isset($colorMap[$code])) {
                $rgb =$colorMap[$code];
                return "<span style='{$rgb}'>{$content}</span>";
            }
            // 无效颜色代码保留原始内容
            return $matches[0];
        }, $string);
        return stringHandle($string);
    }
}

if (!function_exists('stringHandle')) {
    /**
     *  道具描述信息处理
     * @param string $string
     * @return string
     */
    function stringHandle(string $string = "") {
        $string = str_replace(["'", '"', "’", '“', "\\n"], ["@@", "@@@@", "@@", "@@@@", '<br>'], $string);
        return htmlspecialchars(
            $string,
            ENT_QUOTES | ENT_SUBSTITUTE,
            'UTF-8',
            false
        );
    }
}
if (!function_exists('generateOrderNo')) {
    /**
     * 生成唯一订单号（不查表）
     * @param string $prefix 业务前缀（如 R=角色，T=道具 G=金币）
     * @return string
     */
    function generateOrderNo(string $prefix = 'R'): string
    {
        // 1. 时间部分：年月日时分秒 + 微秒（避免同一秒内重复）
        $timePart = date('YmdHis') . substr(microtime(), 2, 4);

        // 2. 随机部分：4位随机数（增强唯一性）
        $randomPart = str_pad(mt_rand(0, 9999), 4, '0', STR_PAD_LEFT);

        // 3. 组合订单号（示例：OR202405301523451234）
        return $prefix . $timePart . $randomPart;
    }
}

if (!function_exists('ispanda')) {
    /**
     * 判断熊猫人角色
     * @param string $username 账号 $serverid 区服
     * @return string
     */
    function ispanda($username, $serverid)
    {
        $ipArr = array(1 => '192.168.6.15', 2 => '192.168.6.15', 3 => '192.168.6.15');
        if (isset($ipArr[$serverid])) {
            $ip = $ipArr[$serverid];
            $key = "0e43c6f0048f8fa220f7ee351782985b";
            $time = time();
            $sign = strtoupper(md5($username . $time . $key));
            $url = "http://{$ip}:9300/iscreatepanda?&userid={$username}&time={$time}&sign={$sign}&";
            $apiinfo = curlGet($url);
            $res = json_decode($apiinfo, true);
            return (int)$res['iscreate'];
        }
    }
}
if (!function_exists('shaiya_roleList')) {
    /**
     * 获取神泣的角色
     * @param string $username 账号 $serverid 区服
     * @return string
     */
    function shaiya_roleList($username, $serverid)
    {
        $ipArr = array(1 => '192.168.6.15', 2 => '192.168.6.15', 3 => '192.168.6.15',4 => '192.168.6.15',5 => '192.168.6.15',6 => '192.168.6.15');
        if (isset($ipArr[$serverid])) {
            $ip = $ipArr[$serverid];
            $key = "0e43c6f0048f8fa220f7ee351782985b";
            $time = time();
            $sign = md5($username . $time . $key);
            $url = "http://{$ip}:9300/getcha?&username={$username}&time={$time}&sign={$sign}&";
            $apiinfo = curlGet($url);
            $res = json_decode($apiinfo, true);
            return $res;
        }
    }
}
if (!function_exists('shaiya5_roleList')) {
    /**
     * 获取神泣的角色
     * @param string $username 账号 $serverid 区服
     * @return string
     */
    function shaiya5_roleList($username, $serverid)
    {
        $ipArr = array(1 => '192.168.6.30');
        if (isset($ipArr[$serverid])) {
            $ip = $ipArr[$serverid];
            $key = "0e43c6f0048f8fa220f7ee351782985b";
            $time = time();
            $sign = md5($username . $time . $key);
            $url = "http://{$ip}:9300/getcha?&username={$username}&time={$time}&sign={$sign}&";
            $apiinfo = curlGet($url);
            $res = json_decode($apiinfo, true);
            return $res;
        }
    }
}

/**
 * 验证Thrift响应有效性
 */
function isValidResponse($response)
{
    return $response &&
        isset($response->code) &&
        $response->code == 200 &&
        !empty($response->data);
}

/**
 * 安全解析响应数据
 */
function parseResponseData($response)
{
    if (empty($response->data)) {
        return null;
    }
    $data = json_decode($response->data);
    if (json_last_error() !== JSON_ERROR_NONE) {
        return null;
    }
    return $data;
}

if (!function_exists('tradeOuttime')) {
    /**
     *  公示期+出售期
     * @return mixed
     */
    function tradeOuttime()
    {
        return config("app.trade_public_time") + config("app.trade_seller_time");
    }
}
if (!function_exists('snakeToMethod')) {
    /**
     * 将蛇形命名转换为方法名
     *
     * @param string $snakeCase 蛇形命名字符串
     * @param array $options 配置选项:
     *                      - 'prefix' => 方法前缀 (默认'get')
     *                      - 'suffix' => 方法后缀 (默认'Data')
     *                      - 'firstUpper' => 首字母是否大写 (默认false)
     * @return string 转换后的方法名
     */
    function snakeToMethod($snakeCase, $options = []) {
        $defaults = [
            'prefix' => 'get',
            'suffix' => 'Data',
            'firstUpper' => false
        ];
        $config = array_merge($defaults, $options);

        $trimmed = trim($snakeCase, ' _');
        $parts = explode('_', $trimmed);

        // 处理首字母大小写
        $firstPart = $config['firstUpper'] ? ucfirst($parts[0]) : lcfirst($parts[0]);
        $parts[0] = $firstPart;

        // 处理其余部分
        $restParts = array_slice($parts, 1);
        $camelRest = implode('', array_map('ucfirst', $restParts));

        return $config['prefix'] . ucfirst($firstPart) . $camelRest . $config['suffix'];
    }
}

if (!function_exists('isFacade')) {
    /**
     *  外观数据
     * @param $game
     * @param $item
     * @return array
     */
    function isFacade($game = "", $item = []) {
        if (!($item['itemid'] ?? 0)) {
            return [];
        }
        // 分类ID值
        $itemType    = config($game . ".itemtype");
        $itemTypeIds = array_keys($itemType);
        $itemtypeid  = intval($item['itemid'] / 1000);

        $isFacade = false;
        $type     = 0;
        if ($item['dex'] >= 3 && $item['extduration'] != -1 && in_array($itemtypeid, $itemTypeIds)) {
            $isFacade = true;
            $type     = $itemType[$itemtypeid];
        }

        return [
            'is_facade' => $isFacade,
            'type'      => $type,
            'typeid'    => $itemtypeid,
        ];
    }
}

if (!function_exists('intToBinary')) {
    /**
     *  int -> bin
     * @param string $value
     * @param int $bits
     * @return string
     */
    function intToBinary(string $value = "", int $bits = 14): string
    {
        return str_pad(decbin($value), $bits, '0', STR_PAD_LEFT);
    }
}

if (!function_exists('handleEnvJsonToArray')) {
    /**
     *  env文件中的json处理转为数组
     * @param string $value
     * @return array
     */
    function handleEnvJsonToArray(string $value = ""): array
    {
        if (!$value) {
            return [];
        }

        $value = trim($value, "'\"");
        return json_decode($value, true);
    }
}

if (!function_exists('__godwing')) {
    /**
     * 天神和翅膀图片
     * @param $game
     * @param $type
     * @param $st
     * @param $data
     * @return mixed|string
     */
    function __godwing($game = "", $type = 0, $st = 0, $data = []) {
        $string = "";
        switch ($type) {
            case 0:
                if ($data) {
                    // 配置列表
                    $icon = calcXAndY($data['icon']);
                    $string = '<img style="background-image: url('.$data['iconset'].');
                            background-position-x:'.$icon['x'].'px;background-position-y:'.$icon['y'].'px;
                            ">';
                }
                break;
        }
        return $string;
    }
}

if (!function_exists('__godwingattr')) {
    /**
     * 天神和翅膀图片
     * @param $game
     * @param $type
     * @param $key
     * @param $st
     * @param $data
     * @return mixed|string
     */
    function __godwingattr($game = "", $type = 0, $key = "", $st = 0, $data = []) {
        switch ($type) {
            case 0:
                // 配置列表
                $configLists = config($game . ".god");
                break;
            case 1:
                // 配置列表
                $configLists = config($game . ".wing");
                break;
        }
        // 配置
        $config = $configLists[$key] ?? "";
        // 配置数据
        $attr = $config["label"] ?? "";
        $options = $config["options"] ?? [];
        $value = $data[$key] ?? "";
        if ($options) {
            $value = $options[$value] ?? "";
        }

        return $attr . "：" . $value;
    }
}