<?php

namespace app\api\middleware;

use app\common\traits\HttpTraits;
use think\Exception;

class AuthMiddleware
{
    use HttpTraits;
    public function handle($request, \Closure $next)
    {
        $data = $request->param();
        if (!$data) {
            throw new Exception("缺少参数");
        }
        $game = $data['game'] ?? "";
        if (!$game) {
            throw new Exception("[game]缺少游戏参数");
        }
        // 交易流水号
        $time = $data['_time'] ?? 0;
        if (!$time) {
            throw new Exception("[_time]参数错误");
        }

        // 校验时间有效期
        if ((time() - $time) > 300) {
            throw new Exception("[_time]参数错误：签名失效");
        }

        $sign = $data['sign'] ?? '';
        if (!$sign) {
            throw new Exception("[sign]参数错误：缺少签名参数");
        }

        $key = config($game.".open_key");
        if (!$key) {
            throw new Exception("服务异常");
        }

        //校验签名
        $checkSign = $this->getSign($data, $key);
//        dd($checkSign);
        if ($sign != $checkSign) {
            throw new Exception("[sign]参数错误：签名错误");
        }

        return $next($request);
    }

    /**
     *  获取签名参数
     * @param array $data
     * @param string $key
     * @return string
     */
    private function getSign(array $data = [], string $key = "")
    {
        // 请求参数必须严格按照接口文档顺序，否则会验签失败
        unset($data['sign']);
        ksort($data);
        return md5(join("", $data) . "" . $key);
    }
}
