<?php
namespace app\api\controller\trade;

use app\common\controller\ApiController;
use app\common\model\Trade;
use think\Exception;

class Record extends ApiController
{
    /**
     *  添加交易记录
     * @return \think\response\Json
     */
    public function add()
    {
        $data = $this->request->param();

        $game = $data['game'] ?? "";
        if (!$game) {
            throw new Exception("[game]缺少游戏参数");
        }

        $serverid = $data['serverid'] ?? 0;
        if (!$serverid) {
            throw new Exception("[serverid]缺少区服参数");
        }

        // 交易类型
        $type = intval($data['type'] ?? 0);
        if (!in_array($type, array_keys(Trade::TYPE))) {
            throw new Exception("[type]参数错误");
        }

        // 玩家ID - 游戏内的uid，不适用
        $userid = $data['userid'] ?? "";
        if (!$userid) {
//            throw new Exception("[userid]缺少玩家ID参数");
        }

        // 玩家账号
        $username = $data['username'] ?? "";
        if (!$username) {
            throw new Exception("[userid]缺少玩家账号参数");
        }

        // 交易流水号
        $syncTradeno = $data['sync_tradeno'] ?? '';
        if (!$syncTradeno) {
            throw new Exception("[sync_tradeno]参数错误");
        }

        // 判断是否重复
        $tradeObj = new Trade();
        $detail =  $tradeObj->getDetailsBySyncTradeno($syncTradeno);
        if ($detail) {
            throw new Exception("数据已存在，无需添加");
        }

        $id = Trade::insertGetId([
            'game' => $game,
            'serverid' => $serverid,
            'type' => $type,
//            'userid' => $userid,
            'username' => $username,
            'sync_tradeno' => $syncTradeno,
            'sync_status' => Trade::T_SYNC_STATUS_TODO,
        ]);
        if (!$id) {
            throw new Exception("上架失败");
        }

        return $this->success('上架成功');
    }
}