<?php

namespace app\admin\service;

use app\common\model\Trade;
use app\common\model\TradeNotice;
use think\Exception;
use think\facade\Db;

class TradeService
{
    /**
     *  管理后台 - 交易关闭
     * @param int $id
     * @param int $type
     * @return array
     */
    public static function close(int $id = 0, int $type = 0): array
    {
        try {
            $model    = Trade::getTypeTradeModel($type);
            $modelObj = app('app\\common\\model\\' . $model);
            $details  = $modelObj->getDetailsByWhere(['id' => $id], ['id', 'game', 'username', 'serverid', 'tid', 'trade_status']);
            if (!$details) {
                throw new Exception("交易不存在");
            }

            $tradeStatus = $details['trade_status'] ?? 0;
            $game        = $details['game'] ?? '';
            $serverid    = $details['serverid'] ?? 0;
            if ($tradeStatus != Trade::T_TRADE_STATUS_PUB) {
                throw new Exception("只允许公示期状态的交易下架");
            }

            $tid         = $details['tid'] ?? 0;
            $trade       = (new Trade())->getDetailsByWhere([
                'id' => $tid, 'game' => $game, 'serverid' => $serverid,
            ], ["id", "game", "serverid", "username", "type", "sync_status", "sync_tradeno"]);
            $syncTradeno = $trade['sync_tradeno'] ?? "";
            if (!$syncTradeno) {
                throw new Exception("交易数据错误");
            }
        } catch (Exception $e) {
            return [
                "status" => false,
                "msg"    => $e->getMessage(),
                "data"   => []
            ];
        }

        $tradeObj = new Trade();
        Db::startTrans();
        try {
            // 下架接口
            $tradeObj->closeTrade([
                'game' => $game, 'serverid' => $serverid, 'tid' => $tid, 'id' => $id, 'type' => $type, 'username' => $details['username'] ?? "",
                'sync_tradeno' => $syncTradeno, 'trade_status' => Trade::T_TRADE_STATUS_ADMIN_DOWN, 'notice_type' => TradeNotice::NOTICE_TYPE_FAILURE,
                'handle_type' => Trade::OP_ADMIN_CLOSE_TRADE
            ]);
            Db::commit();
        } catch (Exception $e) {
            Db::rollback();
            return [
                "status" => false,
                "msg"    => $e->getMessage(),
                "data"   => []
            ];
        }

        return [
            "status" => true,
            "msg"    => "下架成功",
            "data"   => []
        ];
    }
}