<?php

namespace app\admin\model\system;

use app\admin\controller\AdminBase;
use think\facade\Filesystem;
use think\facade\Request;

/**
 * 上传管理
 */
class Upload extends AdminBase
{

    /**
     * 文件上传接口
     * @param $file
     * @return string|\think\response\Json
     */
    public function upfile($file = 'file')
    {
        try{
            $savename = Filesystem::putFile('upload',Request::file($file));
        }catch(\think\Exception $e){
            return $this->returnMsg('上传失败！'.$e->getMessage());
        }
        //获取图片信息
        $fileInfo = Request::file($file)->getFileInfo();
        return $this->returnMsg('上传成功！', 1, ['fileurl'=>'/storage/'.str_replace('\\', '/', $savename)]);
    }


    public function files()
    {
        //返回json数据
        return $this->returnMsg(['group_list'=>[['groupid'=>0,'groupname'=>'全部']],'file_list'=>[]],1);
    }
}