<?php

namespace app\admin\extend\tool;

use think\facade\Db;
use app\admin\model\system\Menus as M;

/**
 * 菜单操作类（主用于插件管理调用）
 */
class Menus
{
    /**
     * 创建菜单
     * @param   array    $menus    菜单数组
     * @param   type     $parent   父类ID
     * @param   string   $name     插件标识名
     * @return  mixed
     */
    public static function create($menus = [], $parent = 0, $name = '')
    {
        $old = [];
        self::menuUpdate($menus, $parent, $name);
        M::cache(1);
    }

    /**
     * 删除菜单
     * @param   string  $name  插件名
     * @return  int  删除的记录数
     */
    public static function delete($name)
    {
        $i = 0;
        if($name){
            $i = M::del(['name'=>$name]);
            if($i>0){
                M::cache(1);
            }
        }
        return $i;
    }

    /**
     * 菜单升级
     * @param  array    $newMenu    新菜单数据
     * @param  int      $parentid   父类ID
     * @param  string   $name       插件标识名
     * @throws Exception
     */
    private static function menuUpdate($newMenu, $parentid = 0, $name = '')
    {
        $allow = ['catid'=>'1','name'=>'','menu_name'=>'莫名菜单','role_name'=>'','link_url'=>'','menu_url'=>'','role_url'=>'','link_url'=>'','icon'=>'','ismenu'=>'0','listorder'=>10,'state'=>'0','type'=>'1'];
        foreach($newMenu as $k => $v){
            $data = array_intersect_key($v, $allow);
            $data = array_merge($allow, $data);
            $data['addtime']   = ZBG_TIME;
            $data['parent_id'] = $parentid;
            $data['role_name'] = $data['role_name'] ?: $data['menu_name'];
            $data['name'] = $name ?: $data['name'];
            $menu = M::create($data);
            if(isset($v['sublist']) && $v['sublist']){
                self::menuUpdate($v['sublist'], $menu['menuid'], $name);
            }
        }
    }

    /**
     * 菜单导出
     * @param  int            $menuid   菜单ID
     * @param  string/array   $where    查询条件
     * @throws Exception
     */
    public static function menuOut($menuid = 0, $where = '')
    {
        global $_MES;
        $_MES = $_MES ?: M::where($where)->order('listorder', 'asc')->column('*');
        $data = [];
        foreach ($_MES as $v){
            if($v['parent_id']==$menuid){
                $v['sublist'] = self::menuOut($v['menuid']);
                if(!$v['icon']) unset($v['icon']);
                if(!$v['link_url']) unset($v['link_url']);
                if(!$v['menu_url']) unset($v['menu_url']);
                if(!$v['sublist']) unset($v['sublist']);
                unset($v['menuid'],$v['addtime'],$v['parent_id']);
                $data[] = $v;
            }
        }
        return $data;
    }

    /**
     * 菜单数据库记录按顺序重建
     * @param   int     $id   顶级ID
     * @param   int     $pd   上级ID
     * @param   array   $rs   菜单集
     * @return  string
     */
    public static function reset($id = 0, $pd = 0, $rs = [])
    {
        if(!$rs){
            $rs = Db::name('menus')->order('listorder asc')->column('*');
            if($rs){
                Db::query("truncate vt_menus");
                self::reset($id,$pd,$rs);
                M::cache(1);
            }
            return 'ok';
        }else{
            $data = [];
            foreach($rs as $v){
                if($v['parent_id']==$id){
                    $menuid = $v['menuid']; unset($v['menuid']);
                    $v['addtime']   = ZBG_TIME;
                    $v['parent_id'] = $pd;
                    $data[$menuid]  = Db::name('menus')->insertGetId($v);
                }
            }
            foreach($data as $k=>$v){
                self::reset($k, $v, $rs);
            }
        }
    }

}