<?php

namespace app\admin\controller\trade;

use app\admin\controller\AdminBase;
use app\common\model\TradeGame;
use app\common\model\TradeItems;
use think\Exception;

/**
 *  道具
 */
class Items extends AdminBase
{
    public function index($do = '')
    {
        if($do=='json') {
            $list = (new TradeItems())->listQuery();
            return $this->returnMsg($list);
        }

        $gameObj = new TradeGame();
        $game    = $gameObj->getGameLists();
        $this->assign([
            'limit'           => 10,
            'game'            => arrayToJson($game['game_lists'] ?? []),
            'serverid'        => arrayToJson($game['serverid_lists'] ?? []),
        ]);
        return $this->fetch();
    }

    /**
     *  编辑道具
     * @return string|\think\response\Json|void
     */
    public function edit()
    {
        if (!$this->request->isPost()) {
            return $this->returnMsg('请求错误');
        }
        $this->checkParams('edit');
        $id = $this->request->post('id', '0');
        $data = $this->request->post();
        unset($data['id']);

        try {
            TradeItems::where('id', $id)->update($data);
        } catch (Exception $e) {
            return $this->returnMsg('编辑失败');
        }

        return $this->returnMsg('编辑成功', 1);
    }

    /**
     *  添加道具
     * @return string|\think\response\Json|void
     */
    public function add()
    {
        if (!$this->request->isPost()) {
            return $this->returnMsg('请求错误');
        }
        $this->checkParams('add');
        $data = $this->request->post();

        try {
            TradeItems::insertGetId($data);
        } catch (Exception $e) {
            return $this->returnMsg('添加失败');
        }

        return $this->returnMsg('添加成功', 1);
    }

    /**
     *  校验参数
     * @return void
     */
    private function checkParams($type = '')
    {
        // 规则
        $commonRules = [
            'game' => 'require|min:1', 'itemname' => 'require|min:1|max:80',
            'iconset' => 'require|min:1',
            'text' => 'require|min:1|max:255',
            'itemid' => 'require|egt:0', 'icon' => 'require|egt:-1', 'level' => 'require|egt:-1', 'dex' => 'require|egt:-1',
            'og' => 'require|egt:-1', 'attacktime' => 'require|egt:-1', 'effect1' => 'require|egt:-1', 'effect2' => 'require|egt:-1',
            'effect3' => 'require|egt:-1', 'effect4' => 'require|egt:-1', 'consthp' => 'require|egt:-1', 'constsp' => 'require|egt:-1',
            'constmp' => 'require|egt:-1', 'conststr' => 'require|egt:-1', 'constdex' => 'require|egt:-1', 'constrec' => 'require|egt:-1',
            'constint' => 'require|egt:-1', 'constwis' => 'require|egt:-1', 'constluc' => 'require|egt:-1', 'extduration' => 'require|egt:-1'
        ];

        // 信息
        $commonMessages = [
            'game.require' => "请选择游戏", 'game.min' => "请选择游戏",
            'itemname.require' => "道具名称不能为空", 'itemname.min' => "道具名称不能为空", 'itemname.max' => "道具名称不能超过80个字符",
            'iconset.require' => "请上传道具图片", 'iconset.min' => "请上传道具图片",
            'text.require' => "请输入道具介绍", 'text.min' => "请输入道具介绍", 'text.max' => "道具介绍不能超过255字符",
            'itemid.require' => "请输入道具ID", 'itemid.egt' => "道具ID须大于等于0",
            'icon.require' => "请输入背包内观", 'icon.egt' => "背包内观须大于等于-1",
            'level.require' => "请输入使用等级", 'level.egt' => "使用等级须大于等于-1",
            'dex.require' => "请输入名称颜色", 'dex.egt' => "名称颜色须大于等于-1",
            'og.require' => "请输入绑定", 'og.egt' => "绑定须大于等于-1",
            'attacktime.require' => "请输入攻速", 'attacktime.egt' => "攻速须大于等于-1",
            'effect1.require' => "请输入攻击力下限", 'effect1.egt' => "攻击力下限须大于等于-1",
            'effect2.require' => "请输入攻击力浮动值", 'effect2.egt' => "攻击力浮动值须大于等于-1",
            'effect3.require' => "请输入防御力", 'effect3.egt' => "防御力须大于等于-1",
            'effect4.require' => "请输入抵抗", 'effect4.egt' => "抵抗须大于等于-1",
            'consthp.require' => "请输入血量加成", 'consthp.egt' => "血量加成须大于等于-1",
            'constsp.require' => "请输入活力加成", 'constsp.egt' => "活力加成须大于等于-1",
            'constmp.require' => "请输入魔力加成", 'constmp.egt' => "魔力加成须大于等于-1",
            'conststr.require' => "请输入力量加成", 'conststr.egt' => "力量加成须大于等于-1",
            'constdex.require' => "请输入敏捷加成", 'constdex.egt' => "敏捷加成须大于等于-1",
            'constrec.require' => "请输入体质加成", 'constrec.egt' => "体质加成须大于等于-1",
            'constint.require' => "请输入智力加成", 'constint.egt' => "智力加成须大于等于-1",
            'constwis.require' => "请输入精神加成", 'constwis.egt' => "精神加成须大于等于-1",
            'constluc.require' => "请输入幸运加成", 'constluc.egt' => "幸运加成须大于等于-1",
            'extduration.require' => "请输入时限", 'extduration.egt' => "时限须大于等于-1",
        ];

        if ($type == 'edit') {
            $commonRules = array_merge([
                'id' => 'require|egt:0',
            ], $commonRules);

            $commonMessages = array_merge([
                'id.require' => "ID不能为空", 'id.egt' => "ID不能为空",
            ], $commonMessages);
        }
        $data = $this->request->post();
        $this->validate($data, $commonRules, $commonMessages);
    }
}