<?php

namespace app\admin\controller\system;

use app\admin\controller\AdminBase;
use think\facade\Filesystem;
use think\facade\Request;

/**
 * 上传管理
 */
class Upload extends AdminBase
{

    /**
     * 文件上传接口
     * @param $file
     * @return string|\think\response\Json
     */
    public function upfile($file = 'file')
    {
        $data = $this->request->request();
        try{
            $fileObj = Request::file($file);
            $groupid = $data['groupid'] ?? "";
            $rule = null;
            $path = 'upload';
            if ($groupid == "items") {
                $rule = function ($fileObj) {
                    return $fileObj->getOriginalName();
                };
                $path = 'images' . DIRECTORY_SEPARATOR . $groupid;
            }

            $savename = Filesystem::putFile($path,$fileObj, $rule);
        }catch(\think\Exception $e){
            return $this->returnMsg('上传失败！'.$e->getMessage());
        }
        //获取图片信息
        return $this->returnMsg('上传成功！', 1, ['fileurl'=>'/storage/'.str_replace('\\', '/', $savename)]);
    }


    public function files()
    {
        //返回json数据
        return $this->returnMsg(['group_list'=>[['groupid'=>0,'groupname'=>'全部']],'file_list'=>[]],1);
    }
}