<?php

namespace app\admin\controller\system;

use app\admin\controller\AdminBase;
use app\admin\model\system\Menus as M;
use app\admin\extend\tool\Menus as T;

/**
 * 后台菜单管理控制器
 */
class Menus extends AdminBase
{
    /**
     * 菜单列表  return T::reset(); //菜单重新构建
     * @param  array   $do   异步数据
     * @return mixed
     */
    public function index($do='')
    {
        if($do=='json'){
            return $this->returnMsg(M::where("type=1")->order(['listorder'=>'asc','menuid'=>'asc'])->select());
        }
        return $this->fetch();
    }

    /**
     * 菜单添加
     */
    public function add()
    {
        $d = $this->only(['menu_name/*/{2,20}/菜单名称','role_name/*/{2,20}/权限名称','link_url/u','menu_url/u','role_url/u','icon/u','parent_id/d','listorder/d','ismenu/d','state/d']);
        $d['addtime'] = ZBG_TIME;
        if(M::insert($d)){
            M::cache(1);
            return $this->returnMsg("添加菜单成功", 1);
        }else{
            return $this->returnMsg('添加菜单失败');
        }
    }

    /**
     * 菜单批量添加
     */
    public function adds()
    {
        $d = $this->only(['titles/h','pid/d']);
        if(!$d['titles']) return $this->returnMsg("请输入菜单名称");
        $id = $d['pid'];
        $rs = M::get(['menuid'=>$id]);
        if($id==0 || $rs){
            $data = [];
            $arr  = explode("\n", $d['titles']);
            foreach($arr as $v){
                if(!is_preg($v,'{2,20}')) continue;
                $data[] = ['menu_name'=>$v,'role_name'=>$v,'parent_id'=>$id,'state'=>0,'listorder'=>10,'addtime'=>ZBG_TIME];
            }
            if(M::insertAll($data)){
                M::cache(1);
                return $this->returnMsg("批量添加成功", 1);
            }else{
                return $this->returnMsg('批量添加失败');
            }
        }else{
            return $this->returnMsg("上级ID不存在");
        }
    }

    /**
     * 菜单编辑
     * @param  string   $do   快编参数
     */
    public function edit($do='')
    {
        $d = $this->only($do ? ['menuid/d/参数错误','av/u','af'] : ['menuid/d/参数错误','menu_name/*/{2,20}/菜单名称','role_name/*/{2,20}/权限名称','link_url/u','menu_url/u','role_url/u','icon/u','parent_id/d','listorder/d','ismenu/d','state/d']);
        $menuid = $d['menuid'];
        $Myobj = M::get("menuid = $menuid");
        if(!$Myobj) return $this->returnMsg("数据不存在");
        if($do=='up'){
            $value = $d['av'];
            $field = $d['af'];
            if(!in_array($field,['menu_name','menu_url','role_url','link_url','listorder','ismenu','state'])) return $this->returnMsg("参数错误");
            if($field=='menu_name'){
                $this->only(['av/*/{2,20}/菜单名称']);
            }elseif(in_array($field,['listorder','ismenu','state'])){
                $value = intval($value);
            }
            $data = $field == 'menu_name' ? [$field=>$value,'role_name'=>$value] : [$field=>$value];
            if($Myobj->save($data)){
                M::cache(1);
                return $this->returnMsg("设置成功", 1);
            }else{
                return $this->returnMsg("设置失败");
            }
        }else{
            $d['addtime'] = ZBG_TIME;
            if($Myobj->save($d)){
                M::cache(1);
                return $this->returnMsg("编辑菜单成功", 1);
            }else{
                return $this->returnMsg("编辑菜单失败");
            }
        }
    }

    /**
     * 菜单删除
     */
    public function del()
    {
        $menuid = $this->only(['menuid'])['menuid'];
        $menuid = is_array($menuid) ? implode(',',$menuid) : $menuid;
        if(!$menuid) return $this->returnMsg('参数错误');
        $rs = M::where("parent_id IN($menuid)")->column("parent_id");
        $menuid = $rs ? implode(',',array_diff(explode(',',$menuid), $rs)) : $menuid;
        if(!$menuid) return $this->returnMsg('删除结构错误');
        if(M::del("menuid IN($menuid) AND type = 1")){
            M::cache(1);
            return $this->returnMsg("删除成功", 1);
        }else{
            return $this->returnMsg("删除失败");
        }
    }

    /**
     * 菜单导出
     */
    public function out()
    {
        $menuid = $this->request->post('menuid/d',0);
        $data = T::menuOut($menuid,'type=1');
        $rs = M::get("menuid = '$menuid'");
        if($rs){
            $rs = $rs->toArray();
            $rs['sublist'] = $data;
            unset($rs['menuid'],$rs['addtime']);
            $data = [$rs];
        }
        $msg = '无数据导出';
        if($data){
            $file = 'sysMenus_'.$menuid.'.php';
            $content = "<?php\nreturn ".var_export($data,true).";";
            $content = preg_replace('/(?<==> \n).*?(?=array)/si', '', $content);
            $content = str_replace(["array (", "),", ");", "=> \n"], ["[", "],", "];", "=> "], $content);
            @file_put_contents(RUNTIME_PATH.$file, $content);
            $msg = '导出成功位置:/runtime/'.$file;
        }
        return $this->returnMsg($msg);
    }

    /**
     * 菜单导入
     */
    public function up()
    {
        set_time_limit(0);
        $code = 0;
        $file = RUNTIME_PATH.'sysMenus.php';
        if(is_file($file)){
            try{
                $data = include($file);
                T::create($data);
                M::cache(1);
                $msg = '导入成功';
                $code = 1;
            }catch(\think\db\exception\PDOException $e){
                $msg = $e->getMessage();
            }
        }else{
            $msg = '找不到菜单数据:/runtime/sysMenus.php';
        }
        return $this->returnMsg($msg,$code);
    }


}