<?php

namespace app\admin\controller\system;

use app\admin\controller\AdminBase;
use app\admin\model\system\LoginLog;
use app\admin\model\system\ManagerLog;
use app\admin\model\system\WebLog;

/**
 * 后台管理日志控制器
 */
class Log extends AdminBase
{
    /**
     * 日志管理主面板
     * @return mixed
     */
    public function index()
    {
        $this->assign([
            'limit' => 20,
        ]);
        return $this->fetch();
    }

    /**
     * 登录日志
     * @param  string  $do  异步操作
     */
    public function login($do='')
    {
        $Log = new LoginLog();
        if($do=='check'){
            $d = $this->only(['logid/d','password']);
            $rs = $Log->where('logid',$d['logid'])->field('password,passsalt')->find();
            $m = $rs && set_password($d['password'], $rs['passsalt']) == $rs['password'] ? '校验结果匹配' : '校验不匹配';
            return $this->returnMsg($m,1);
        }
        $list = $Log->listQuery()->toArray();
        foreach($list['data'] as &$v){
            $v['password'] = substr($v['password'], 0, 6).'******'.substr($v['password'], 26);
            if($this->manUser['userid']>1){
                $ip = explode('.', $v['loginip']);
                $v['loginip'] = $ip[0].'. *** .'.$ip[3];
            }
            unset($v['passsalt']);
        }
        return $this->returnMsg($list);
    }

    /**
     * 管理日志
     */
    public function manager()
    {
        $list = (new ManagerLog())->listQuery()->toArray();
        if($this->manUser['userid']>1){
            foreach($list['data'] as &$v){
                $ip = explode('.', $v['ip']);
                $v['ip'] = $ip[0].'. *** .'.$ip[3];
            }
        }
        return $this->returnMsg($list);
    }
}