<?php
namespace app\admin\controller\order;

use app\admin\controller\AdminBase;
use app\common\model\Trade;
use app\common\model\TradeGame;
use app\common\model\TradeStats;

class StatsTrade extends AdminBase
{
    public function index($do = '')
    {
        if ($do == 'json') {
            $list = (new TradeStats())->listQuery();
            return $this->returnMsg($list);
        }

        $gameObj = new TradeGame();
        $game    = $gameObj->getGameLists();

        $this->assign([
            'limit'           => 10,
            'game'            => arrayToJson($game['game_lists'] ?? []),
            'serverid'        => arrayToJson($game['serverid_lists'] ?? []),
            'ordertype'       => arrayToJson(Trade::TYPE),
            'type'            => arrayToJson(TradeStats::STATS_TYPES),
        ]);
        return $this->fetch();
    }
}