<?php
namespace app\admin\controller\order;

use app\admin\controller\AdminBase;
use app\admin\service\TradeService;
use app\common\constant\CacheKey;
use app\common\constant\CommonKey;
use app\common\model\Trade;
use app\common\model\TradeGame;
use app\common\model\TradeRole;
use app\common\model\TradeOrder;
use app\common\model\TradeWithdraw;
use app\common\service\FileLockService;
use think\Exception;

class RolesTrade extends AdminBase
{
    /**
     * 列表
     * @param $do
     * @return string|\think\response\Json
     */
    public function index($do = '')
    {
        if ($do == 'json') {
            $list = (new TradeRole())->listQuery();
            return $this->returnMsg($list);
        }
        $gameObj = new TradeGame();
        $game    = $gameObj->getGameLists();
        $this->assign([
            'limit'           => 10,
            'game'            => arrayToJson($game['game_lists'] ?? []),
            'serverid'        => arrayToJson($game['serverid_lists'] ?? []),
            'api_status'      => arrayToJson(Trade::T_API_STATUS),
            'pay_status'      => arrayToJson(Trade::TYPE_PAY_STATUS),
            'trade_status'    => arrayToJson(Trade::T_TRADE_STATUS),
            'withdraw_status' => arrayToJson(TradeOrder::TO_WITHDRAW_STATUS),
            'sync_status'     => arrayToJson(Trade::T_SYNC_STATUS),
        ]);
        return $this->fetch();
    }

    /**
     * 查看
     * @param $do
     * @return string
     */
    public function details($do = '')
    {
        $id = (int)$this->request->get('id');

        $tradeObj = new Trade();
        $rolesTradeObj = new TradeRole();
        $tradeOrderObj = new TradeOrder();
        $withdrawObj   = new TradeWithdraw();

        // 交易记录
        $details = $rolesTradeObj->getDetailsByWhere(['id' => $id]);

        $res   = $rolesTradeObj->handleRawData($details);
        $details = $res['rows'] ?? [];
        unset($res);

        $tid      = $details['tid'] ?? 0;
        $game     = $details['game'] ?? "";
        $serverid = $details['serverid'] ?? 0;

        $stLists = config($game . ".st");
        $roleDetails = $rolesTradeObj->getRoleDetails($tid, $game, $serverid);

        // 同步数据状态
        $trade = $tradeObj->getDetailsByWhere(['id' => $tid], ['sync_status']);
        $details['sync_status'] = $trade['sync_status'] ?? 0;

        // 订单数据
        $order = $tradeOrderObj->getOrderDetailsByTid($tid, TradeOrder::ORDERTYPE_ROLES);
        if ($order) {
            $order['paytime_text'] = $order['paytime'] ? date('Y-m-d H:i:s', $order['paytime']) : '--';
        }

        // 提现信息
        $withdraw = $withdrawObj->getDetailsByWhere(['tid' => $tid]);
        if ($withdraw) {
            $withdraw['alitime_text'] = $withdraw['alitime'] ? date('Y-m-d H:i:s', $withdraw['alitime']) : '--';
            $withdraw['withdrawtime_text'] = $withdraw['withdrawtime'] ? date('Y-m-d H:i:s', $withdraw['withdrawtime']) : '--';
        }

        $gameObj = new TradeGame();
        $gameInfoLists    = $gameObj->getGameLists();
        $this->assign([
            'trade'             => $details ?: [],
            'order'             => $order ?: [],
            'withdraw'          => $withdraw ?: [],
            'warLists'          => $roleDetails['warLists'] ?? [],
            'equipLists'        => $roleDetails['equipLists'] ?? [],
            'stLists'           => $stLists,
            'packsackLists'     => $roleDetails['backpackLists'][0] ?? [], // 背包道具
            'roleBackpackLists' => $roleDetails['backpackLists'][1] ?? [], // 角色仓库
            'godPartLists'      => $roleDetails['godPartLists'] ?? [], // 天神属性列表
            'wingLists'         => $roleDetails['wingLists'] ?? [], // 翅膀属性列表
            'facadeLists'       => $roleDetails['facadeLists'] ?? [], // 外观
            'game'              => $gameInfoLists['game_lists'] ?? [],
            'serverid'          => $gameInfoLists['serverid_lists'] ?? [],
            'api_status'        => Trade::T_API_STATUS,
            'pay_status'        => Trade::TYPE_PAY_STATUS,
            'trade_status'      => Trade::T_TRADE_STATUS,
            'withdraw_status'   => TradeWithdraw::WITHDRAW_STATUS,
            'sync_status'       => Trade::T_SYNC_STATUS,
            'ispanda'           => TradeRole::RTR_ISPANDA,
            'itemTypeLists'     => config($game . ".item_type_lists"), // 分类
            'roleItemTips'      => config($game . ".role_item_details_tips"),
        ]);
        return $this->fetch();
    }

    /**
     *  交易下架
     * @return string|\think\response\Json
     */
    public function close()
    {
        $id = $this->request->post('id');

        try {
            $obj = new FileLockService();
            $lockKey = sprintf(CacheKey::ADMIN_TRADE_CLOSE_LOCK, Trade::TYPE_ROLES, $id);
            $fp = $obj->acquireLock($lockKey, CommonKey::EXPIRED_THREE_SECOND);
            if ($fp === false) {
                throw new Exception("操作频繁");
            }

            $res = TradeService::close($id, Trade::TYPE_ROLES);
            if (($res['status'] ?? false) === false) {
                throw new Exception($res["msg"] ?? "下架失败");
            }
        } catch (Exception $e) {
            return $this->returnMsg($res["msg"] ?? "下架失败");
        } finally {
            if ($fp !== false) {
                $obj->deleteLockFile($fp, $lockKey);
            }
        }

        return $this->returnMsg("下架成功", 1);
    }
}