<?php
namespace app\admin\controller\order;

use app\admin\controller\AdminBase;
use app\admin\service\TradeService;
use app\common\constant\CacheKey;
use app\common\constant\CommonKey;
use app\common\model\Trade;
use app\common\model\TradeEquip;
use app\common\model\TradeGame;
use app\common\model\TradeItems;
use app\common\model\TradeOrder;
use app\common\model\TradeProp;
use app\common\model\TradeWithdraw;
use app\common\service\FileLockService;
use think\Exception;

class PropTrade extends AdminBase
{
    public function index($do = '')
    {
        if ($do == 'json') {
            $list = (new TradeProp())->listQuery();
            return $this->returnMsg($list);
        }

        $gameObj = new TradeGame();
        $game    = $gameObj->getGameLists();

        $this->assign([
            'limit'           => 10,
            'game'            => arrayToJson($game['game_lists'] ?? []),
            'serverid'        => arrayToJson($game['serverid_lists'] ?? []),
            'api_status'      => arrayToJson(Trade::T_API_STATUS),
            'pay_status'      => arrayToJson(Trade::TYPE_PAY_STATUS),
            'trade_status'    => arrayToJson(Trade::T_TRADE_STATUS),
            'withdraw_status' => arrayToJson(TradeOrder::WITHDRAW_STATUS),
        ]);
        return $this->fetch();
    }

    /**
     * 查看
     * @param $do
     * @return string
     */
    public function details($do = '')
    {
        $id = $this->request->get('id');

        $propTradeObj  = new TradeProp();
        $tradeOrderObj = new TradeOrder();
        $withdrawObj   = new TradeWithdraw();

        // 交易记录
        $trade = $propTradeObj->getDetailsByWhere(['id' => $id]);

        $game        = $trade['game'] ?? "";
        $serverid    = $trade['serverid'] ?? 0;
        $itemid      = $trade['itemid'] ?? 0;

        // 获取职业
        $cjLists = (new TradeEquip())->getEquipListsByTids($game, $serverid, [$trade['tid'] ?? 0], ['cj', 'itemid']);
        $cjLists = array_column($cjLists, "cj", 'itemid');


        $trade['cj'] = $cjLists[$itemid] ?? 0;
        $itemDetails = (new TradeItems())->getDetailsByItemid($game, $serverid, $itemid);
        $res = $propTradeObj->handleRawData($trade, $itemDetails);
        $trade = $res['rows'] ?? [];
        $itemDetails = $res['item'] ?? [];
        unset($res);

        $tid = $trade['tid'] ?? 0;
        // 订单数据
        $order = $tradeOrderObj->getOrderDetailsByTid($tid, TradeOrder::ORDERTYPE_PROP);
        if ($order) {
            $order['paytime_text'] = $order['paytime'] ? date('Y-m-d H:i:s', $order['paytime']) : '--';
            $trade['charge'] = $order['charge'] ?? 0;
        }

        $withdraw = $withdrawObj->getDetailsByWhere(['tid' => $tid]);
        if ($withdraw) {
            $withdraw['alitime_text'] = $withdraw['alitime'] ? date('Y-m-d H:i:s', $withdraw['alitime']) : '--';
            $withdraw['withdrawtime_text'] = $withdraw['withdrawtime'] ? date('Y-m-d H:i:s', $withdraw['withdrawtime']) : '--';
        }

        $gameObj = new TradeGame();
        $gameInfoLists    = $gameObj->getGameLists();
        $this->assign([
            'trade'           => $trade ?: [],
            'order'           => $order ?: [],
            'withdraw'        => $withdraw ?: [],
            'item'            => $itemDetails ?: [],
            'game'            => $gameInfoLists['game_lists'] ?? [],
            'serverid'        => $gameInfoLists['serverid_lists'] ?? [],
            'api_status'      => Trade::T_API_STATUS,
            'pay_status'      => Trade::TYPE_PAY_STATUS,
            'trade_status'    => Trade::T_TRADE_STATUS,
            'withdraw_status' => TradeWithdraw::WITHDRAW_STATUS,
        ]);
        return $this->fetch();
    }

    /**
     *  交易下架
     * @return string|\think\response\Json
     */
    public function close()
    {
        $id = $this->request->post('id');

        try {
            $obj = new FileLockService();
            $lockKey = sprintf(CacheKey::ADMIN_TRADE_CLOSE_LOCK, Trade::TYPE_PROP, $id);
            $fp = $obj->acquireLock($lockKey, CommonKey::EXPIRED_THREE_SECOND);
            if ($fp === false) {
                throw new Exception("操作频繁");
            }

            $res = TradeService::close($id, Trade::TYPE_PROP);
            if (($res['status'] ?? false) === false) {
                throw new Exception($res["msg"] ?? "下架失败");
            }
        } catch (Exception $e) {
            return $this->returnMsg($res["msg"] ?? "下架失败");
        } finally {
            if ($fp !== false) {
                $obj->deleteLockFile($fp, $lockKey);
            }
        }

        return $this->returnMsg("下架成功", 1);
    }
}