<?php
namespace app\admin\controller\order;

use app\admin\controller\AdminBase;
use app\common\model\Trade;
use app\common\model\TradeGame;
use app\common\model\TradeNotice;

class NoticeTrade extends AdminBase
{
    public function index($do = '')
    {
        if ($do == 'json') {
            $list = (new TradeNotice())->listQuery();
            return $this->returnMsg($list);
        }

        $gameObj = new TradeGame();
        $game    = $gameObj->getGameLists();

        $this->assign([
            'limit'           => 10,
            'game'            => arrayToJson($game['game_lists'] ?? []),
            'serverid'        => arrayToJson($game['serverid_lists'] ?? []),
            'type'            => arrayToJson(Trade::TYPE),
        ]);
        return $this->fetch();
    }

    /**
     * 查看
     * @param $do
     * @return string
     */
    public function details($do = '')
    {
        $id      = $this->request->get('id');
        $details = (new TradeNotice())->getDetailsByWhere(['id' => $id]);
        $gameObj = new TradeGame();
        $game    = $gameObj->getGameLists();
        $this->assign([
            'details'  => $details,
            'types'    => Trade::TYPE,
            'game'     => $game['game_lists'] ?? [],
            'serverid' => $game['serverid_lists'] ?? [],
        ]);
        return $this->fetch();
    }
}