<?php
namespace app\admin\controller\help;

use app\admin\controller\AdminBase;
use app\common\model\TradeHelpCate;
use think\Exception;

class Cate extends AdminBase
{
    /**
     *  列表
     * @param $do
     * @return string|\think\response\Json
     */
    public function index($do = '')
    {
        if($do=='json') {
            $list = (new TradeHelpCate())->listQuery();
            return $this->returnMsg($list);
        }

        $this->assign([
            'limit' => 10,
        ]);
        return $this->fetch();
    }

    /**
     *  添加
     * @return string|\think\response\Json
     */
    public function add()
    {
        if (!$this->request->isPost()) {
            return $this->returnMsg('请求错误');
        }

        $this->checkParams('add');
        $data = $this->request->post();

        try {
            TradeHelpCate::insertGetId($data);
        } catch (Exception $e) {
            return $this->returnMsg('添加失败');
        }

        return $this->returnMsg('添加成功', 1);
    }

    /**
     *  编辑
     * @return string|\think\response\Json
     */
    public function edit()
    {
        if (!$this->request->isPost()) {
            return $this->returnMsg('请求错误');
        }

        $this->checkParams('edit');

        $id = $this->request->post('id', '0');
        $data = $this->request->post();
        unset($data['id']);

        try {
            TradeHelpCate::where('id', $id)->update($data);
        } catch (Exception $e) {
            return $this->returnMsg('编辑失败');
        }

        return $this->returnMsg('编辑成功', 1);
    }

    /**
     *  参数校验
     * @param string $type
     * @return void
     */
    private function checkParams(string $type)
    {
        // 规则
        $commonRules = [
            'name' => 'require|min:1|max:80',
            'sort' => 'require|min:0',
            'status' => 'require|in:0,1',
        ];

        // 信息
        $commonMessages = [
            'name.require' => "分类名称不能为空", 'name.min' => "分类名称不能为空", 'name.max' => "分类名称不能超过80个字符",
            'sort.require' => "排序参数错误", 'iconset.min' => "排序参数错误",
            'status.require' => "分类状态错误", 'status.in' => "分类状态错误"
        ];

        if ($type == 'edit') {
            $commonRules = array_merge([
                'id' => 'require|egt:0',
            ], $commonRules);

            $commonMessages = array_merge([
                'id.require' => "ID不能为空", 'id.egt' => "ID不能为空",
            ], $commonMessages);
        }
        $data = $this->request->post();
        $this->validate($data, $commonRules, $commonMessages);
    }
}