<?php
namespace app\admin\controller\help;

use app\admin\controller\AdminBase;
use app\common\model\TradeHelpArticle;
use app\common\model\TradeHelpCate;
use think\Exception;
use think\helper\Str;

class Article extends AdminBase
{
    /**
     *  列表
     * @param $do
     * @return string|\think\response\Json
     */
    public function index($do = '')
    {
        if($do=='json') {
            $list = (new TradeHelpArticle())->listQuery();
            return $this->returnMsg($list);
        }

        $cateLists = TradeHelpCate::field(['id', 'name'])->select()->toArray();
        $this->assign([
            'limit' => 10,
            'cate_lists' => arrayToJson($cateLists),
        ]);
        return $this->fetch();
    }

    /**
     *  添加
     * @return string|\think\response\Json
     */
    public function add()
    {
        if (!$this->request->isPost()) {
            return $this->returnMsg('请求错误');
        }

        $this->checkParams('add');
        $data = $this->request->post();

        try {
            $data['mark'] = Str::random(32);
            TradeHelpArticle::insertGetId($data);
        } catch (Exception $e) {
            return $this->returnMsg('添加失败');
        }

        return $this->returnMsg('添加成功', 1);
    }

    /**
     *  编辑
     * @return string|\think\response\Json
     */
    public function edit()
    {
        if (!$this->request->isPost()) {
            return $this->returnMsg('请求错误');
        }

        $this->checkParams('edit');
        $id = $this->request->post('id', '0');
        $data = $this->request->post();
        unset($data['id']);

        try {
            TradeHelpArticle::where('id', $id)->update($data);
        } catch (Exception $e) {
            return $this->returnMsg('编辑失败');
        }

        return $this->returnMsg('编辑成功', 1);
    }

    /**
     *  参数校验
     * @param string $type
     * @return void
     */
    private function checkParams(string $type)
    {
        // 规则
        $commonRules = [
            'title' => 'require|min:1|max:80',
            'cate_id' => 'require|min:1',
            'sort' => 'require|min:0',
            'status' => 'require|in:0,1',
            'content' => 'require',
        ];

        // 信息
        $commonMessages = [
            'title.require' => "分类名称不能为空", 'title.min' => "分类名称不能为空", 'title.max' => "分类名称不能超过80个字符",
            'cate_id.require' => "请选择文章分类", 'cate_id.min' => "请选择文章分类",
            'sort.require' => "排序参数错误", 'iconset.min' => "排序参数错误",
            'status.require' => "分类状态错误", 'status.in' => "分类状态错误",
            'content.require' => "文章内容",
        ];

        if ($type == 'edit') {
            $commonRules = array_merge([
                'id' => 'require|egt:0',
            ], $commonRules);

            $commonMessages = array_merge([
                'id.require' => "ID不能为空", 'id.egt' => "ID不能为空",
            ], $commonMessages);
        }
        $data = $this->request->post();
        $this->validate($data, $commonRules, $commonMessages);
    }
}