<?php

namespace app\admin\controller;

use app\admin\BaseController;
use app\admin\model\system\Manager;
use app\admin\model\system\LoginLog;
use app\admin\model\system\Online;
use app\admin\extend\tool\Lock;
use app\admin\model\system\Roles;

/**
 * 后台登录
 */
class Login extends BaseController
{
    /**
     * 登录首页
     */
    public function index()
    {
        if(!empty(session(ZBG_MANAGER))) return $this->redirect(APP_MAP);
        return $this->fetch();
    }

    /**
     * 退出系统
     */
    public function logout()
    {
        $User = session(ZBG_MANAGER);
        if($User) Online::where([['userid','=',$User['userid']],['ip','=',ZBG_IP]])->delete(); //删除在线数据
        session(ZBG_MANAGER,null); //清空Session
        return $this->redirect(url('admin/login/index')->build());
    }

    /**
     * 解锁屏处理
     */
    public function unlock()
    {
        if(is_null($us=session(ZBG_MANAGER))) return $this->returnMsg('还未登录');
        $password = $this->request->post('password','');
        if($us['password'] === set_password($password,$us['passsalt'])){
            return $this->returnMsg('success',1);
        }else{
            return $this->returnMsg('解锁密码错误');
        }
    }

    /**
     * 登录验证
     */
    public function check()
    {
        //多次尝试验证
        if(Lock::check()) return $this->returnMsg(Lock::msg());
        $d = $this->only(['username/*/u/管理帐号','password/*/p/登录密码','captcha']);
        if(!captcha_check($d['captcha'])) return $this->returnMsg('验证码错误！');
        $username = $d['username'];
        $password = $d['password'];
        //查询用户数据
        $rs = Manager::get(compact('username'));
        if(empty($rs)){
            LoginLog::add($username, $password, '', '账号错误');
            Lock::add();
            return $this->returnMsg('帐号或密码错误！');
        }
        if($rs->state == 0) return $this->returnMsg('帐号已被停用！');
        if($rs['password'] === set_password($password,$rs['passsalt'])){
            $rs->logintime = ZBG_TIME;
            $rs->loginip   = ZBG_IP;
            $rs->logins ++;
            $rs->save();
            LoginLog::add($username, $password, $rs['passsalt']);
            session(ZBG_MANAGER,$rs->toArray());
            Lock::del();
            return $this->returnMsg('登录成功！',1,['url'=>APP_MAP]);
        }
        LoginLog::add($username, $password, $rs['passsalt'], '密码错误');
        Lock::add();
        return $this->returnMsg('帐号或密码错误！');
    }

    /**
     *  自动登录
     * @return string|\think\response\Json
     */
    public function auto()
    {
        if ($this->request->isPost()) {
            $token = $this->request->post('token', '');
            $code  = $this->request->post('code', '');
            if ($token != 'admin') {
                return $this->returnMsg("进入失败：token参数错误");
            }

            return $this->returnMsg('进入成功', 1, ['url' => APP_MAP]);
        }

        $this->assign([
            "data" => $this->request->param()
        ]);
        return $this->fetch();
    }
}