<?php

namespace app\admin\controller;

use app\admin\model\system\Menus;
use think\facade\Cache;

/**
 * 后台主控制器
 */
class Index extends AdminBase
{
    /**
     * 后台首页
     * @return mixed
     */
    public function index()
    {
        return $this->fetch();
    }

    /**
     * 后台主面板
     * @return mixed
     */
    public function main()
    {
        return $this->fetch();
    }

    /**
     * 获取左侧菜单和用户信息
     */
    public function json()
    {
        $arr = [];
        $data = Menus::getMenus(array_intersect_key($this->manUser, ['userid'=>"",'role_menuid'=>""])); // 获取拥有的菜单数据
        $rs =[
            'menus' => $data,
            'user'  => $this->manUser
        ];
        unset($rs['user']['password'],$rs['user']['passsalt']);
        return json($rs);
    }
 
    /**
     * 清空缓存
     */
    public function clear(){
        Cache::clear();
        return $this->returnMsg("清理缓存成功!");
    }

}