<?php

namespace app\admin\controller;

use app\admin\BaseController;
use app\admin\model\system\ManagerLog;
use app\admin\model\system\Online;
use app\admin\model\system\Roles;
use app\admin\model\system\Manager;

/**
 *【后台控制器抽象基类】
 */
abstract class AdminBase extends BaseController
{
    /**
     * 后台管理员信息
     * @var array
     */
    protected $manUser = [];

    /**
     * 当前路由uri
     * @var string
     */
    protected $routeUri = '';

    protected $lang = '';
    /**
     * 后台控制器验证初始化
     */
    protected function __auth()
    {
        //lang
        $this->lang = $this->app->lang->getLangSet() ?? 'cn';
        //验证登录
        $this->isLogin();
        //载入权限菜单
        $this->loadMenusRoles();
        //获取控制器名
        $controller = $this->request->controller();
        //合取方法
        $url = $controller."/".$this->request->action();
        //构组路由: 控制器 + 方法 + （参数action的传值）
        $this->routeUri = strtolower(ADDON_APP.$url.(($action = $this->request->get('action')) ? '/'.$action : ''));
        //验证权限
        $this->isPower();
    }

    /**
     * 登录判断
     */
    private function isLogin()
    {
        if(is_null($this->manUser=session(ZBG_MANAGER))){
            $url = ADDON_APP ? '/' : APP_MAP.'/login/index';
            if($this->request->isAjax()){
                $this->exitMsg('您还未登录或已过期，请先登录！',401,['url'=>$url]);
            }else{
                header("Location:".$url);
                exit();
            }
        }
    }

    /**
     * 载入管理员角色权限菜单
     */
    private function loadMenusRoles()
    {
        $us = $this->manUser;
        $rs = Manager::get("username='$us[username]' AND state>0");
        if($rs && $us['password']==$rs['password'] && $us['passsalt']==$rs['passsalt']){
            //禁止同帐号同时异地登录处理
//            if($rs['loginip']!=ZBG_IP){      //IP一直变化，不知为何
//                session(ZBG_MANAGER,null);
//                $url = ADDON_APP ? '/' : APP_MAP.'/login/index';
//                if($this->request->isAjax()){
//                    $this->exitMsg('您的帐号已在其他终端登录！',401,['url'=>$url]);
//                }else{
//                    $this->exitMsg('您的帐号已在其他终端登录！',303,['url'=>$url]);
//                }
//            }
            $us = $rs->toArray();
            session(ZBG_MANAGER,$us);
            $us['role_menuid'] = '';
            $us['role_name']   = '超级管理员';
            $this->manUser = $us['userid']>1 ? array_merge($us, Roles::cache($us['roleid'])) : $us;
        }else{
            session(ZBG_MANAGER,null);
            $url = ADDON_APP ? '/' : APP_MAP.'/login/index';
            if($this->request->isAjax()){
                $this->exitMsg('您还未登录或已过期，请先登录！',401,['url'=>$url]);
            }else{
                $this->exitMsg('您还未登录或已过期，请重新登录！',303,['url'=>$url]);
            }
        }
    }

    /**
     * 权限判断
     */
    private function isPower()
    {
        if($this->manUser['userid']>1 && !in_array($this->routeUri,$this->manUser['actions'])){
            if($this->request->isAjax()){
                $this->exitMsg('抱歉，您没有该项权限请联系管理员！',401);
            }else{
                header("Content-type:text/html;charset=utf-8");
                exit('抱歉，您没有该项权限请联系管理员！');
            }
        }
    }

    /**
     * 日志/在线处理
     * @access  protected
     */
    protected function logon(string $tip = '')
    {
        //操作日志
        ManagerLog::add(['url'=>$this->routeUri.($tip ? ' '.$tip : ''),'username'=>$this->manUser['username'],'ip'=>ZBG_IP]);
        Online::create(['userid'=>$this->manUser['userid'],'username'=>$this->manUser['username'],'url'=>$this->routeUri,'etime'=>ZBG_TIME,'ip'=>ZBG_IP],['userid','username','url','etime','ip'],true);
    }
    /**
     * 重写验证规则
     *
     * @param array        $data
     * @param array|string $validate
     * @param array        $message
     * @param bool         $batch
     *
     * @return array|bool|string|true
     */
    public function validate(array $data, $validate, array $message = [], bool $batch = null)
    {
        return parent::validate($data, $validate, $message, $batch);
    }
}